/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.ksql.rest.entity.FunctionInfo;
import io.confluent.ksql.rest.entity.FunctionType;
import io.confluent.ksql.rest.entity.KsqlEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FunctionDescriptionList
extends KsqlEntity {
    private final String name;
    private final String description;
    private final String author;
    private final String version;
    private final Collection<FunctionInfo> functions;
    private final String path;
    private final FunctionType type;

    @JsonCreator
    public FunctionDescriptionList(@JsonProperty(value="statementText") String statementText, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="author") String author, @JsonProperty(value="version") String version, @JsonProperty(value="path") String path, @JsonProperty(value="functions") Collection<FunctionInfo> functions, @JsonProperty(value="type") FunctionType type) {
        super(statementText);
        this.name = Objects.requireNonNull(name, "name can't be null");
        this.description = Objects.requireNonNull(description, "description can't be null");
        this.author = Objects.requireNonNull(author, "author can't be null");
        this.version = Objects.requireNonNull(version, "version can't be null");
        this.path = Objects.requireNonNull(path, "path can't be null");
        this.functions = Objects.requireNonNull(functions, "functions can't be null");
        this.type = Objects.requireNonNull(type, "type can't be null");
    }

    public Collection<FunctionInfo> getFunctions() {
        return Collections.unmodifiableCollection(this.functions);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPath() {
        return this.path;
    }

    public FunctionType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionDescriptionList that = (FunctionDescriptionList)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.author, that.author) && Objects.equals(this.version, that.version) && Objects.equals(this.functions, that.functions) && Objects.equals(this.path, that.path) && Objects.equals((Object)this.type, (Object)that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.author, this.version, this.functions, this.path, this.type});
    }

    public String toString() {
        return "FunctionDescriptionList{name='" + this.name + "', description='" + this.description + "', author='" + this.author + "', version='" + this.version + "', functions=" + String.valueOf(this.functions) + ", path='" + this.path + "', type='" + this.type.name() + "'}";
    }
}

