/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.ksql.rest.entity.FunctionType;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SimpleFunctionInfo
implements Comparable<SimpleFunctionInfo> {
    private final String name;
    private final FunctionType type;
    private final String category;

    @JsonCreator
    public SimpleFunctionInfo(@JsonProperty(value="name") String name, @JsonProperty(value="type") FunctionType type, @JsonProperty(value="category") String category) {
        this.name = Objects.requireNonNull(name, "name can't be null");
        this.type = Objects.requireNonNull(type, "type can't be null");
        this.category = Objects.isNull(category) ? "" : category;
    }

    public String getName() {
        return this.name;
    }

    public FunctionType getType() {
        return this.type;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleFunctionInfo that = (SimpleFunctionInfo)o;
        return Objects.equals(this.name, that.name) && this.type == that.type && Objects.equals(this.category, that.category);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.category});
    }

    public String toString() {
        return "SimpleFunctionInfo{name='" + this.name + "', type='" + String.valueOf((Object)this.type) + "', category=" + this.category + "}";
    }

    @Override
    public int compareTo(SimpleFunctionInfo other) {
        return this.name.compareTo(other.name);
    }
}

