/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.entity.KsqlEntity;
import io.confluent.ksql.rest.entity.SchemaInfo;
import java.util.Map;
import java.util.Objects;

@Immutable
@JsonIgnoreProperties(ignoreUnknown=true)
public class TypeList
extends KsqlEntity {
    private final ImmutableMap<String, SchemaInfo> types;

    @JsonCreator
    public TypeList(@JsonProperty(value="statementText") String statementText, @JsonProperty(value="types") Map<String, SchemaInfo> types) {
        super(statementText);
        this.types = ImmutableMap.copyOf(Objects.requireNonNull(types, "types"));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="types is ImmutableMap")
    public Map<String, SchemaInfo> getTypes() {
        return this.types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeList typeList = (TypeList)o;
        return Objects.equals(this.types, typeList.types);
    }

    public int hashCode() {
        return Objects.hash(this.types);
    }
}

