/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.interpreter;

import org.projectnessie.cel.common.containers.Container;
import org.projectnessie.cel.common.types.ref.TypeAdapter;
import org.projectnessie.cel.common.types.ref.TypeProvider;
import org.projectnessie.cel.interpreter.AttributeFactory;
import org.projectnessie.cel.interpreter.Dispatcher;
import org.projectnessie.cel.interpreter.EvalState;
import org.projectnessie.cel.interpreter.Interpretable;
import org.projectnessie.cel.interpreter.InterpretableDecorator;
import org.projectnessie.cel.interpreter.InterpretablePlanner;
import org.projectnessie.cel.interpreter.functions.Overload;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.CheckedExpr;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Expr;

public interface Interpreter {
    public Interpretable newInterpretable(CheckedExpr var1, InterpretableDecorator ... var2);

    public Interpretable newUncheckedInterpretable(Expr var1, InterpretableDecorator ... var2);

    public static InterpretableDecorator trackState(EvalState state) {
        return InterpretableDecorator.decObserveEval(state::setValue);
    }

    public static InterpretableDecorator exhaustiveEval(EvalState state) {
        InterpretableDecorator ex = InterpretableDecorator.decDisableShortcircuits();
        InterpretableDecorator obs = Interpreter.trackState(state);
        return i -> {
            Interpretable iDec = ex.decorate(i);
            return obs.decorate(iDec);
        };
    }

    public static InterpretableDecorator optimize() {
        return InterpretableDecorator.decOptimize();
    }

    public static Interpreter newInterpreter(Dispatcher dispatcher, Container container, TypeProvider provider, TypeAdapter adapter, AttributeFactory attrFactory) {
        return new ExprInterpreter(dispatcher, container, provider, adapter, attrFactory);
    }

    public static Interpreter newStandardInterpreter(Container container, TypeProvider provider, TypeAdapter adapter, AttributeFactory resolver) {
        Dispatcher dispatcher = Dispatcher.newDispatcher();
        dispatcher.add(Overload.standardOverloads());
        return Interpreter.newInterpreter(dispatcher, container, provider, adapter, resolver);
    }

    public static final class ExprInterpreter
    implements Interpreter {
        private final Dispatcher dispatcher;
        private final Container container;
        private final TypeProvider provider;
        private final TypeAdapter adapter;
        private final AttributeFactory attrFactory;

        ExprInterpreter(Dispatcher dispatcher, Container container, TypeProvider provider, TypeAdapter adapter, AttributeFactory attrFactory) {
            this.dispatcher = dispatcher;
            this.container = container;
            this.provider = provider;
            this.adapter = adapter;
            this.attrFactory = attrFactory;
        }

        @Override
        public Interpretable newInterpretable(CheckedExpr checked, InterpretableDecorator ... decorators) {
            InterpretablePlanner p = InterpretablePlanner.newPlanner(this.dispatcher, this.provider, this.adapter, this.attrFactory, this.container, checked, decorators);
            return p.plan(checked.getExpr());
        }

        @Override
        public Interpretable newUncheckedInterpretable(Expr expr, InterpretableDecorator ... decorators) {
            InterpretablePlanner p = InterpretablePlanner.newUncheckedPlanner(this.dispatcher, this.provider, this.adapter, this.attrFactory, this.container, decorators);
            return p.plan(expr);
        }
    }
}

