/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.parser;

import java.util.Arrays;
import java.util.List;
import org.projectnessie.cel.common.Location;
import org.projectnessie.cel.parser.ExprHelper;
import org.projectnessie.cel.parser.Helper;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Expr;
import org.projectnessie.cel.relocated.com.google.protobuf.ByteString;

public final class ExprHelperImpl
implements ExprHelper {
    final Helper parserHelper;
    final long id;

    public ExprHelperImpl(Helper parserHelper, long id) {
        this.parserHelper = parserHelper;
        this.id = id;
    }

    long nextMacroID() {
        return this.parserHelper.id(this.parserHelper.getLocation(this.id));
    }

    @Override
    public Expr literalBool(boolean value) {
        return this.parserHelper.newLiteralBool(this.nextMacroID(), value);
    }

    @Override
    public Expr literalBytes(ByteString value) {
        return this.parserHelper.newLiteralBytes(this.nextMacroID(), value);
    }

    @Override
    public Expr literalDouble(double value) {
        return this.parserHelper.newLiteralDouble(this.nextMacroID(), value);
    }

    @Override
    public Expr literalInt(long value) {
        return this.parserHelper.newLiteralInt(this.nextMacroID(), value);
    }

    @Override
    public Expr literalString(String value) {
        return this.parserHelper.newLiteralString(this.nextMacroID(), value);
    }

    @Override
    public Expr literalUint(long value) {
        return this.parserHelper.newLiteralUint(this.nextMacroID(), value);
    }

    @Override
    public Expr newList(List<Expr> elems) {
        return this.parserHelper.newList(this.nextMacroID(), elems);
    }

    @Override
    public Expr newList(Expr ... elems) {
        return this.newList(Arrays.asList(elems));
    }

    @Override
    public Expr newMap(List<Expr.CreateStruct.Entry> entries) {
        return this.parserHelper.newMap(this.nextMacroID(), entries);
    }

    @Override
    public Expr.CreateStruct.Entry newMapEntry(Expr key, Expr val) {
        return this.parserHelper.newMapEntry(this.nextMacroID(), key, val);
    }

    @Override
    public Expr newObject(String typeName, List<Expr.CreateStruct.Entry> fieldInits) {
        return this.parserHelper.newObject(this.nextMacroID(), typeName, fieldInits);
    }

    @Override
    public Expr.CreateStruct.Entry newObjectFieldInit(String field, Expr init) {
        return this.parserHelper.newObjectField(this.nextMacroID(), field, init);
    }

    @Override
    public Expr fold(String iterVar, Expr iterRange, String accuVar, Expr accuInit, Expr condition, Expr step, Expr result) {
        return this.parserHelper.newComprehension(this.nextMacroID(), iterVar, iterRange, accuVar, accuInit, condition, step, result);
    }

    @Override
    public Expr ident(String name) {
        return this.parserHelper.newIdent(this.nextMacroID(), name);
    }

    @Override
    public Expr globalCall(String function, List<Expr> args) {
        return this.parserHelper.newGlobalCall((Object)this.nextMacroID(), function, args);
    }

    @Override
    public Expr globalCall(String function, Expr ... args) {
        return this.globalCall(function, Arrays.asList(args));
    }

    @Override
    public Expr receiverCall(String function, Expr target, List<Expr> args) {
        return this.parserHelper.newReceiverCall(this.nextMacroID(), function, target, args);
    }

    @Override
    public Expr presenceTest(Expr operand, String field) {
        return this.parserHelper.newPresenceTest(this.nextMacroID(), operand, field);
    }

    @Override
    public Expr select(Expr operand, String field) {
        return this.parserHelper.newSelect(this.nextMacroID(), operand, field);
    }

    @Override
    public Location offsetLocation(long exprID) {
        return this.parserHelper.getLocation(exprID);
    }
}

