/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.parser;

import java.util.List;
import org.projectnessie.cel.common.debug.Debug;
import org.projectnessie.cel.common.operators.Operator;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Constant;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Expr;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.SourceInfo;

public final class Unparser {
    private final SourceInfo info;
    private final StringBuilder str;

    public static String unparse(Expr expr, SourceInfo info) {
        Unparser unparser = new Unparser(info);
        unparser.visit(expr);
        return unparser.str.toString();
    }

    private Unparser(SourceInfo info) {
        this.info = info;
        this.str = new StringBuilder();
    }

    void visit(Expr expr) {
        switch (expr.getExprKindCase()) {
            case CALL_EXPR: {
                this.visitCall(expr.getCallExpr());
                break;
            }
            case COMPREHENSION_EXPR: {
                this.visitComprehension(expr.getComprehensionExpr());
                break;
            }
            case CONST_EXPR: {
                this.visitConst(expr.getConstExpr());
                break;
            }
            case IDENT_EXPR: {
                this.visitIdent(expr.getIdentExpr());
                break;
            }
            case LIST_EXPR: {
                this.visitList(expr.getListExpr());
                break;
            }
            case SELECT_EXPR: {
                this.visitSelect(expr.getSelectExpr());
                break;
            }
            case STRUCT_EXPR: {
                this.visitStruct(expr.getStructExpr());
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported expr: %s", expr.getClass().getSimpleName()));
            }
        }
    }

    void visitCall(Expr.Call expr) {
        Operator op = Operator.byId(expr.getFunction());
        if (op != null) {
            switch (op) {
                case Conditional: {
                    this.visitCallConditional(expr);
                    return;
                }
                case Index: {
                    this.visitCallIndex(expr);
                    return;
                }
                case LogicalNot: 
                case Negate: {
                    this.visitCallUnary(expr);
                    return;
                }
                case Add: 
                case Divide: 
                case Equals: 
                case Greater: 
                case GreaterEquals: 
                case In: 
                case Less: 
                case LessEquals: 
                case LogicalAnd: 
                case LogicalOr: 
                case Modulo: 
                case Multiply: 
                case NotEquals: 
                case OldIn: 
                case Subtract: {
                    this.visitCallBinary(expr);
                    return;
                }
            }
        }
        this.visitCallFunc(expr);
    }

    void visitCallBinary(Expr.Call expr) {
        String fun = expr.getFunction();
        List<Expr> args = expr.getArgsList();
        Expr lhs = args.get(0);
        boolean lhsParen = this.isComplexOperatorWithRespectTo(fun, lhs);
        Expr rhs = args.get(1);
        boolean rhsParen = this.isComplexOperatorWithRespectTo(fun, rhs);
        if (!rhsParen && this.isLeftRecursive(fun)) {
            rhsParen = this.isSamePrecedence(Operator.precedence(fun), rhs);
        }
        this.visitMaybeNested(lhs, lhsParen);
        String unmangled = Operator.findReverseBinaryOperator(fun);
        if (unmangled == null) {
            throw new IllegalStateException(String.format("cannot unmangle operator: %s", fun));
        }
        this.str.append(" ");
        this.str.append(unmangled);
        this.str.append(" ");
        this.visitMaybeNested(rhs, rhsParen);
    }

    void visitCallConditional(Expr.Call expr) {
        List<Expr> args = expr.getArgsList();
        boolean nested = this.isSamePrecedence(Operator.Conditional.precedence, args.get(0)) || this.isComplexOperator(args.get(0));
        this.visitMaybeNested(args.get(0), nested);
        this.str.append(" ? ");
        nested = this.isSamePrecedence(Operator.Conditional.precedence, args.get(1)) || this.isComplexOperator(args.get(1));
        this.visitMaybeNested(args.get(1), nested);
        this.str.append(" : ");
        nested = this.isSamePrecedence(Operator.Conditional.precedence, args.get(2)) || this.isComplexOperator(args.get(2));
        this.visitMaybeNested(args.get(2), nested);
    }

    void visitCallFunc(Expr.Call expr) {
        String fun = expr.getFunction();
        List<Expr> args = expr.getArgsList();
        if (expr.hasTarget()) {
            boolean nested = this.isBinaryOrTernaryOperator(expr.getTarget());
            this.visitMaybeNested(expr.getTarget(), nested);
            this.str.append(".");
        }
        this.str.append(fun);
        this.str.append("(");
        for (int i = 0; i < args.size(); ++i) {
            if (i > 0) {
                this.str.append(", ");
            }
            this.visit(args.get(i));
        }
        this.str.append(")");
    }

    void visitCallIndex(Expr.Call expr) {
        List<Expr> args = expr.getArgsList();
        boolean nested = this.isBinaryOrTernaryOperator(args.get(0));
        this.visitMaybeNested(args.get(0), nested);
        this.str.append("[");
        this.visit(args.get(1));
        this.str.append("]");
    }

    void visitCallUnary(Expr.Call expr) {
        String fun = expr.getFunction();
        List<Expr> args = expr.getArgsList();
        String unmangled = Operator.findReverse(fun);
        if (unmangled == null) {
            throw new IllegalStateException(String.format("cannot unmangle operator: %s", fun));
        }
        this.str.append(unmangled);
        boolean nested = this.isComplexOperator(args.get(0));
        this.visitMaybeNested(args.get(0), nested);
    }

    void visitComprehension(Expr.Comprehension expr) {
        throw new IllegalStateException(String.format("unimplemented : %s", expr.getClass().getSimpleName()));
    }

    void visitConst(Constant v) {
        this.str.append(Debug.formatLiteral(v));
    }

    void visitIdent(Expr.Ident expr) {
        this.str.append(expr.getName());
    }

    void visitList(Expr.CreateList expr) {
        List<Expr> elems = expr.getElementsList();
        this.str.append("[");
        for (int i = 0; i < elems.size(); ++i) {
            if (i > 0) {
                this.str.append(", ");
            }
            Expr elem = elems.get(i);
            this.visit(elem);
        }
        this.str.append("]");
    }

    void visitSelect(Expr.Select expr) {
        if (expr.getTestOnly()) {
            this.str.append("has(");
        }
        boolean nested = !expr.getTestOnly() && this.isBinaryOrTernaryOperator(expr.getOperand());
        this.visitMaybeNested(expr.getOperand(), nested);
        this.str.append(".");
        this.str.append(expr.getField());
        if (expr.getTestOnly()) {
            this.str.append(")");
        }
    }

    void visitStruct(Expr.CreateStruct expr) {
        if (!expr.getMessageName().isEmpty()) {
            this.visitStructMsg(expr);
        } else {
            this.visitStructMap(expr);
        }
    }

    void visitStructMsg(Expr.CreateStruct expr) {
        List<Expr.CreateStruct.Entry> entries = expr.getEntriesList();
        this.str.append(expr.getMessageName());
        this.str.append("{");
        for (int i = 0; i < entries.size(); ++i) {
            if (i > 0) {
                this.str.append(", ");
            }
            Expr.CreateStruct.Entry entry = entries.get(i);
            String f = entry.getFieldKey();
            this.str.append(f);
            this.str.append(": ");
            Expr v = entry.getValue();
            this.visit(v);
        }
        this.str.append("}");
    }

    void visitStructMap(Expr.CreateStruct expr) {
        List<Expr.CreateStruct.Entry> entries = expr.getEntriesList();
        this.str.append("{");
        for (int i = 0; i < entries.size(); ++i) {
            if (i > 0) {
                this.str.append(", ");
            }
            Expr.CreateStruct.Entry entry = entries.get(i);
            Expr k = entry.getMapKey();
            this.visit(k);
            this.str.append(": ");
            Expr v = entry.getValue();
            this.visit(v);
        }
        this.str.append("}");
    }

    void visitMaybeNested(Expr expr, boolean nested) {
        if (nested) {
            this.str.append("(");
        }
        this.visit(expr);
        if (nested) {
            this.str.append(")");
        }
    }

    boolean isLeftRecursive(String op) {
        Operator o = Operator.byId(op);
        return o != Operator.LogicalAnd && o != Operator.LogicalOr;
    }

    boolean isSamePrecedence(int opPrecedence, Expr expr) {
        if (expr.getExprKindCase() != Expr.ExprKindCase.CALL_EXPR) {
            return false;
        }
        String other = expr.getCallExpr().getFunction();
        return opPrecedence == Operator.precedence(other);
    }

    boolean isLowerPrecedence(String op, Expr expr) {
        if (expr.getExprKindCase() != Expr.ExprKindCase.CALL_EXPR) {
            return false;
        }
        String other = expr.getCallExpr().getFunction();
        return Operator.precedence(op) < Operator.precedence(other);
    }

    boolean isComplexOperator(Expr expr) {
        return expr.getExprKindCase() == Expr.ExprKindCase.CALL_EXPR && expr.getCallExpr().getArgsCount() >= 2;
    }

    boolean isComplexOperatorWithRespectTo(String op, Expr expr) {
        if (!this.isComplexOperator(expr)) {
            return false;
        }
        return this.isLowerPrecedence(op, expr);
    }

    boolean isBinaryOrTernaryOperator(Expr expr) {
        if (!this.isComplexOperator(expr)) {
            return false;
        }
        boolean isBinaryOp = Operator.findReverseBinaryOperator(expr.getCallExpr().getFunction()) != null;
        return isBinaryOp || this.isSamePrecedence(Operator.Conditional.precedence, expr);
    }
}

