/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona;

import org.projectnessie.cel.relocated.org.agrona.DirectBuffer;

public final class PrintBufferUtil {
    private static final String NEWLINE;
    private static final String EMPTY_STRING = "";
    private static final String[] BYTE2HEX_PAD;

    private PrintBufferUtil() {
    }

    public static String hexDump(DirectBuffer buffer) {
        return PrintBufferUtil.hexDump(buffer, 0, buffer.capacity());
    }

    public static String hexDump(DirectBuffer buffer, int fromIndex, int length) {
        return HexUtil.hexDump(buffer, fromIndex, length);
    }

    public static String hexDump(byte[] array) {
        return PrintBufferUtil.hexDump(array, 0, array.length);
    }

    public static String hexDump(byte[] array, int fromIndex, int length) {
        return HexUtil.hexDump(array, fromIndex, length);
    }

    public static String prettyHexDump(DirectBuffer buffer) {
        return PrintBufferUtil.prettyHexDump(buffer, 0, buffer.capacity());
    }

    public static String prettyHexDump(DirectBuffer buffer, int offset, int length) {
        return HexUtil.prettyHexDump(buffer, offset, length);
    }

    public static void appendPrettyHexDump(StringBuilder dump, DirectBuffer buffer) {
        PrintBufferUtil.appendPrettyHexDump(dump, buffer, 0, buffer.capacity());
    }

    public static void appendPrettyHexDump(StringBuilder dump, DirectBuffer buffer, int offset, int length) {
        HexUtil.appendPrettyHexDump(dump, buffer, offset, length);
    }

    public static String byteToHexStringPadded(int value) {
        return BYTE2HEX_PAD[value & 0xFF];
    }

    static {
        int i;
        NEWLINE = System.lineSeparator();
        BYTE2HEX_PAD = new String[256];
        for (i = 0; i < 10; ++i) {
            PrintBufferUtil.BYTE2HEX_PAD[i] = "0" + i;
        }
        while (i < 16) {
            char c = (char)(97 + i - 10);
            PrintBufferUtil.BYTE2HEX_PAD[i] = "0" + c;
            ++i;
        }
        while (i < BYTE2HEX_PAD.length) {
            PrintBufferUtil.BYTE2HEX_PAD[i] = Integer.toHexString(i);
            ++i;
        }
    }

    static final class HexUtil {
        private static final char[] BYTE2CHAR;
        private static final char[] HEXDUMP_TABLE;
        private static final String[] HEX_PADDING;
        private static final String[] HEXDUMP_ROW_PREFIXES;
        private static final String[] BYTE2HEX;
        private static final String[] BYTE_PADDING;

        HexUtil() {
        }

        static short getUnsignedByte(DirectBuffer buffer, int index) {
            return (short)(buffer.getByte(index) & 0xFF);
        }

        static String hexDump(DirectBuffer buffer, int fromIndex, int length) {
            if (length < 0) {
                throw new IllegalArgumentException("length: " + length);
            }
            if (length == 0) {
                return PrintBufferUtil.EMPTY_STRING;
            }
            int endIndex = fromIndex + length;
            char[] buf = new char[length << 1];
            int dstIdx = 0;
            int srcIdx = fromIndex;
            while (srcIdx < endIndex) {
                System.arraycopy(HEXDUMP_TABLE, HexUtil.getUnsignedByte(buffer, srcIdx) << 1, buf, dstIdx, 2);
                ++srcIdx;
                dstIdx += 2;
            }
            return new String(buf);
        }

        static String hexDump(byte[] array, int fromIndex, int length) {
            if (length < 0) {
                throw new IllegalArgumentException("length < 0: " + length);
            }
            if (length == 0) {
                return PrintBufferUtil.EMPTY_STRING;
            }
            int endIndex = fromIndex + length;
            char[] buf = new char[length << 1];
            int dstIdx = 0;
            int srcIdx = fromIndex;
            while (srcIdx < endIndex) {
                System.arraycopy(HEXDUMP_TABLE, (array[srcIdx] & 0xFF) << 1, buf, dstIdx, 2);
                ++srcIdx;
                dstIdx += 2;
            }
            return new String(buf);
        }

        static String prettyHexDump(DirectBuffer buffer, int offset, int length) {
            if (length == 0) {
                return PrintBufferUtil.EMPTY_STRING;
            }
            int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
            StringBuilder stringBuilder = new StringBuilder(rows * 80);
            HexUtil.appendPrettyHexDump(stringBuilder, buffer, offset, length);
            return stringBuilder.toString();
        }

        static boolean isOutOfBounds(int index, int length, int capacity) {
            return (index | length | index + length | capacity - (index + length)) < 0;
        }

        static void appendPrettyHexDump(StringBuilder dump, DirectBuffer buffer, int offset, int length) {
            if (HexUtil.isOutOfBounds(offset, length, buffer.capacity())) {
                throw new IndexOutOfBoundsException("expected: 0 <= offset(" + offset + ") <= offset + length(" + length + ") <= buffer.capacity(" + buffer.capacity() + ')');
            }
            if (length == 0) {
                return;
            }
            dump.append("         +-------------------------------------------------+").append(NEWLINE).append("         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |").append(NEWLINE).append("+--------+-------------------------------------------------+----------------+");
            int fullRows = length >>> 4;
            int remainder = length & 0xF;
            for (int row = 0; row < fullRows; ++row) {
                int j;
                int rowStartIndex = (row << 4) + offset;
                HexUtil.appendHexDumpRowPrefix(dump, row, rowStartIndex);
                int rowEndIndex = rowStartIndex + 16;
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2HEX[HexUtil.getUnsignedByte(buffer, j)]);
                }
                dump.append(" |");
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2CHAR[HexUtil.getUnsignedByte(buffer, j)]);
                }
                dump.append('|');
            }
            if (remainder != 0) {
                int j;
                int rowStartIndex = (fullRows << 4) + offset;
                HexUtil.appendHexDumpRowPrefix(dump, fullRows, rowStartIndex);
                int rowEndIndex = rowStartIndex + remainder;
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2HEX[HexUtil.getUnsignedByte(buffer, j)]);
                }
                dump.append(HEX_PADDING[remainder]);
                dump.append(" |");
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2CHAR[HexUtil.getUnsignedByte(buffer, j)]);
                }
                dump.append(BYTE_PADDING[remainder]);
                dump.append('|');
            }
            dump.append(NEWLINE).append("+--------+-------------------------------------------------+----------------+");
        }

        static void appendHexDumpRowPrefix(StringBuilder dump, int row, int rowStartIndex) {
            if (row < HEXDUMP_ROW_PREFIXES.length) {
                dump.append(HEXDUMP_ROW_PREFIXES[row]);
            } else {
                dump.append(NEWLINE);
                dump.append(Long.toHexString((long)rowStartIndex & 0xFFFFFFFFL | 0x100000000L));
                dump.setCharAt(dump.length() - 9, '|');
                dump.append('|');
            }
        }

        static {
            int j;
            StringBuilder buf;
            int i;
            BYTE2CHAR = new char[256];
            HEXDUMP_TABLE = new char[1024];
            HEX_PADDING = new String[16];
            HEXDUMP_ROW_PREFIXES = new String[4096];
            BYTE2HEX = new String[256];
            BYTE_PADDING = new String[16];
            char[] digits = "0123456789abcdef".toCharArray();
            for (i = 0; i < 256; ++i) {
                HexUtil.HEXDUMP_TABLE[i << 1] = digits[i >>> 4 & 0xF];
                HexUtil.HEXDUMP_TABLE[(i << 1) + 1] = digits[i & 0xF];
            }
            for (i = 0; i < HEX_PADDING.length; ++i) {
                int padding = HEX_PADDING.length - i;
                buf = new StringBuilder(padding * 3);
                for (j = 0; j < padding; ++j) {
                    buf.append("   ");
                }
                HexUtil.HEX_PADDING[i] = buf.toString();
            }
            for (i = 0; i < HEXDUMP_ROW_PREFIXES.length; ++i) {
                StringBuilder buf2 = new StringBuilder(12);
                buf2.append(NEWLINE);
                buf2.append(Long.toHexString((long)i << 4 & 0xFFFFFFFFL | 0x100000000L));
                buf2.setCharAt(buf2.length() - 9, '|');
                buf2.append('|');
                HexUtil.HEXDUMP_ROW_PREFIXES[i] = buf2.toString();
            }
            for (i = 0; i < BYTE2HEX.length; ++i) {
                HexUtil.BYTE2HEX[i] = ' ' + PrintBufferUtil.byteToHexStringPadded(i);
            }
            for (i = 0; i < BYTE_PADDING.length; ++i) {
                int padding = BYTE_PADDING.length - i;
                buf = new StringBuilder(padding);
                for (j = 0; j < padding; ++j) {
                    buf.append(' ');
                }
                HexUtil.BYTE_PADDING[i] = buf.toString();
            }
            for (i = 0; i < BYTE2CHAR.length; ++i) {
                HexUtil.BYTE2CHAR[i] = (char)(i <= 31 || i >= 127 ? 46 : (char)i);
            }
        }
    }
}

