/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona.collections;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class ArrayUtil {
    public static final int UNKNOWN_INDEX = -1;
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final int MAX_CAPACITY = 0x7FFFFFF7;

    private ArrayUtil() {
    }

    public static <T> T[] add(T[] oldElements, T elementToAdd) {
        int length = oldElements.length;
        T[] newElements = Arrays.copyOf(oldElements, length + 1);
        newElements[length] = elementToAdd;
        return newElements;
    }

    public static <T> T[] remove(T[] oldElements, T elementToRemove) {
        int length = oldElements.length;
        int index = -1;
        for (int i = 0; i < length; ++i) {
            if (oldElements[i] != elementToRemove) continue;
            index = i;
        }
        return ArrayUtil.remove(oldElements, index);
    }

    public static <T> T[] remove(T[] oldElements, int index) {
        if (index == -1) {
            return oldElements;
        }
        int oldLength = oldElements.length;
        int newLength = oldLength - 1;
        T[] newElements = ArrayUtil.newArray(oldElements, newLength);
        int j = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (index == i) continue;
            newElements[j++] = oldElements[i];
        }
        return newElements;
    }

    public static <T> T[] newArray(T[] oldElements, int length) {
        return (Object[])Array.newInstance(oldElements.getClass().getComponentType(), length);
    }

    public static <T> T[] ensureCapacity(T[] oldElements, int requiredLength) {
        T[] result = oldElements;
        if (oldElements.length < requiredLength) {
            result = Arrays.copyOf(oldElements, requiredLength);
        }
        return result;
    }
}

