/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona.collections;

import java.util.function.Consumer;
import java.util.function.LongFunction;

public final class LongLruCache<E>
implements AutoCloseable {
    private final int capacity;
    private final LongFunction<E> factory;
    private final Consumer<E> closer;
    private final long[] keys;
    private final Object[] values;
    private int size;

    public LongLruCache(int capacity, LongFunction<E> factory, Consumer<E> closer) {
        this.capacity = capacity;
        this.factory = factory;
        this.closer = closer;
        this.keys = new long[capacity];
        this.values = new Object[capacity];
        this.size = 0;
    }

    public E lookup(long key) {
        int size = this.size;
        long[] keys = this.keys;
        Object[] values = this.values;
        for (int i = 0; i < size; ++i) {
            if (key != keys[i]) continue;
            Object value = values[i];
            this.makeMostRecent(key, value, i);
            return (E)value;
        }
        E value = this.factory.apply(key);
        if (value != null) {
            if (this.capacity == size) {
                this.closer.accept(values[size - 1]);
            } else {
                this.size = ++size;
            }
            this.makeMostRecent(key, value, size - 1);
        }
        return value;
    }

    private void makeMostRecent(long key, Object value, int fromIndex) {
        long[] keys = this.keys;
        Object[] values = this.values;
        for (int i = fromIndex; i > 0; --i) {
            keys[i] = keys[i - 1];
            values[i] = values[i - 1];
        }
        keys[0] = key;
        values[0] = value;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public void close() {
        Consumer<E> closer = this.closer;
        Object[] values = this.values;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            closer.accept(values[i]);
        }
    }
}

