/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona.collections;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;
import org.projectnessie.cel.relocated.org.agrona.BitUtil;
import org.projectnessie.cel.relocated.org.agrona.collections.CollectionUtil;
import org.projectnessie.cel.relocated.org.agrona.collections.Hashing;

public class Object2IntCounterMap<K> {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final int initialValue;
    private int resizeThreshold;
    private int size = 0;
    private K[] keys;
    private int[] values;

    public Object2IntCounterMap(int initialValue) {
        this(8, 0.65f, initialValue);
    }

    public Object2IntCounterMap(int initialCapacity, float loadFactor, int initialValue) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.initialValue = initialValue;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity));
        this.keys = new Object[capacity];
        this.values = new int[capacity];
        Arrays.fill(this.values, initialValue);
        this.resizeThreshold = (int)((float)capacity * loadFactor);
    }

    public int initialValue() {
        return this.initialValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public int capacity() {
        return this.values.length;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int get(K key) {
        int value;
        int initialValue = this.initialValue;
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        while (initialValue != (value = values[index]) && !Objects.equals(keys[index], key)) {
            ++index;
            index &= mask;
        }
        return value;
    }

    public int put(K key, int value) {
        int initialValue = this.initialValue;
        if (initialValue == value) {
            throw new IllegalArgumentException("cannot accept initialValue");
        }
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        int oldValue = initialValue;
        while (values[index] != initialValue) {
            if (Objects.equals(keys[index], key)) {
                oldValue = values[index];
                break;
            }
            ++index;
            index &= mask;
        }
        if (oldValue == initialValue) {
            ++this.size;
            keys[index] = key;
        }
        values[index] = value;
        this.increaseCapacity();
        return oldValue;
    }

    public int incrementAndGet(K key) {
        return this.addAndGet(key, 1);
    }

    public int decrementAndGet(K key) {
        return this.addAndGet(key, -1);
    }

    public int addAndGet(K key, int amount) {
        return this.getAndAdd(key, amount) + amount;
    }

    public int getAndIncrement(K key) {
        return this.getAndAdd(key, 1);
    }

    public int getAndDecrement(K key) {
        return this.getAndAdd(key, -1);
    }

    public int getAndAdd(K key, int amount) {
        int initialValue = this.initialValue;
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        int oldValue = initialValue;
        while (initialValue != values[index]) {
            if (Objects.equals(keys[index], key)) {
                oldValue = values[index];
                break;
            }
            ++index;
            index &= mask;
        }
        if (amount != 0) {
            int newValue;
            values[index] = newValue = oldValue + amount;
            if (initialValue == oldValue) {
                ++this.size;
                keys[index] = key;
                this.increaseCapacity();
            } else if (initialValue == newValue) {
                --this.size;
                this.compactChain(index);
            }
        }
        return oldValue;
    }

    public void forEach(ObjIntConsumer<K> consumer) {
        int initialValue = this.initialValue;
        K[] keys = this.keys;
        int[] values = this.values;
        int length = values.length;
        int remaining = this.size;
        for (int i = 0; remaining > 0 && i < length; ++i) {
            if (initialValue == values[i]) continue;
            consumer.accept(keys[i], values[i]);
            --remaining;
        }
    }

    public boolean containsKey(K key) {
        return this.initialValue != this.get(key);
    }

    public boolean containsValue(int value) {
        boolean found = false;
        if (this.initialValue != value) {
            for (int v : this.values) {
                if (value != v) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.keys, null);
            Arrays.fill(this.values, this.initialValue);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    public int computeIfAbsent(K key, ToIntFunction<? super K> mappingFunction) {
        int value = this.get(key);
        if (this.initialValue == value && this.initialValue != (value = mappingFunction.applyAsInt(key))) {
            this.put(key, value);
        }
        return value;
    }

    public int remove(K key) {
        int initialValue = this.initialValue;
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(key, mask);
        int oldValue = initialValue;
        while (initialValue != values[index]) {
            if (Objects.equals(keys[index], key)) {
                oldValue = values[index];
                values[index] = initialValue;
                --this.size;
                this.compactChain(index);
                break;
            }
            ++index;
            index &= mask;
        }
        return oldValue;
    }

    public int minValue() {
        int initialValue = this.initialValue;
        int min = 0 == this.size ? initialValue : Integer.MAX_VALUE;
        for (int value : this.values) {
            if (initialValue == value) continue;
            min = Math.min(min, value);
        }
        return min;
    }

    public int maxValue() {
        int initialValue = this.initialValue;
        int max = 0 == this.size ? initialValue : Integer.MIN_VALUE;
        for (int value : this.values) {
            if (initialValue == value) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int initialValue = this.initialValue;
        K[] keys = this.keys;
        int[] values = this.values;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            int value = values[i];
            if (initialValue == value) continue;
            sb.append(keys[i]).append('=').append(value).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    private void compactChain(int deleteIndex) {
        int initialValue = this.initialValue;
        K[] keys = this.keys;
        int[] values = this.values;
        int mask = values.length - 1;
        int index = deleteIndex;
        while (true) {
            ++index;
            int value = values[index &= mask];
            if (initialValue == value) break;
            K key = keys[index];
            int hash = Hashing.hash(key, mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            keys[deleteIndex] = key;
            values[deleteIndex] = value;
            keys[index] = null;
            values[index] = initialValue;
            deleteIndex = index;
        }
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.values.length * 2;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        Object[] tempKeys = new Object[newCapacity];
        int[] tempValues = new int[newCapacity];
        int initialValue = this.initialValue;
        Arrays.fill(tempValues, initialValue);
        K[] keys = this.keys;
        int[] values = this.values;
        int size = values.length;
        for (int i = 0; i < size; ++i) {
            int value = values[i];
            if (initialValue == value) continue;
            K key = keys[i];
            int index = Hashing.hash(key, mask);
            while (initialValue != tempValues[index]) {
                ++index;
                index &= mask;
            }
            tempKeys[index] = key;
            tempValues[index] = value;
        }
        this.keys = tempKeys;
        this.values = tempValues;
    }
}

