/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona.concurrent;

import java.util.concurrent.locks.LockSupport;
import org.projectnessie.cel.relocated.org.agrona.concurrent.IdleStrategy;
import org.projectnessie.cel.relocated.org.agrona.concurrent.status.StatusIndicatorReader;
import org.projectnessie.cel.relocated.org.agrona.hints.ThreadHints;

public final class ControllableIdleStrategy
implements IdleStrategy {
    public static final String ALIAS = "controllable";
    public static final int NOT_CONTROLLED = 0;
    public static final int NOOP = 1;
    public static final int BUSY_SPIN = 2;
    public static final int YIELD = 3;
    public static final int PARK = 4;
    private static final long PARK_PERIOD_NANOSECONDS = 1000L;
    private final StatusIndicatorReader statusIndicator;

    public ControllableIdleStrategy(StatusIndicatorReader statusIndicator) {
        this.statusIndicator = statusIndicator;
    }

    @Override
    public void idle(int workCount) {
        if (workCount > 0) {
            return;
        }
        this.idle();
    }

    @Override
    public void idle() {
        int status = (int)this.statusIndicator.getVolatile();
        switch (status) {
            case 1: {
                break;
            }
            case 2: {
                ThreadHints.onSpinWait();
                break;
            }
            case 3: {
                Thread.yield();
                break;
            }
            default: {
                LockSupport.parkNanos(1000L);
            }
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public String alias() {
        return ALIAS;
    }

    public String toString() {
        return "ControllableIdleStrategy{alias=controllable, statusIndicator=" + this.statusIndicator + '}';
    }
}

