/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona.concurrent;

import java.util.concurrent.locks.LockSupport;
import org.projectnessie.cel.relocated.org.agrona.concurrent.IdleStrategy;

public final class SleepingIdleStrategy
implements IdleStrategy {
    public static final String ALIAS = "sleep-ns";
    public static final long DEFAULT_SLEEP_PERIOD_NS = 1000L;
    private final long sleepPeriodNs;

    public SleepingIdleStrategy() {
        this.sleepPeriodNs = 1000L;
    }

    public SleepingIdleStrategy(long sleepPeriodNs) {
        this.sleepPeriodNs = sleepPeriodNs;
    }

    @Override
    public void idle(int workCount) {
        if (workCount > 0) {
            return;
        }
        LockSupport.parkNanos(this.sleepPeriodNs);
    }

    @Override
    public void idle() {
        LockSupport.parkNanos(this.sleepPeriodNs);
    }

    @Override
    public void reset() {
    }

    @Override
    public String alias() {
        return ALIAS;
    }

    public String toString() {
        return "SleepingIdleStrategy{alias=sleep-ns, sleepPeriodNs=" + this.sleepPeriodNs + '}';
    }
}

