/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona.concurrent;

import org.projectnessie.cel.relocated.org.agrona.concurrent.AbstractSnowflakeIdGeneratorPaddingRhs;
import org.projectnessie.cel.relocated.org.agrona.concurrent.EpochClock;
import org.projectnessie.cel.relocated.org.agrona.concurrent.IdGenerator;
import org.projectnessie.cel.relocated.org.agrona.concurrent.SystemEpochClock;
import org.projectnessie.cel.relocated.org.agrona.hints.ThreadHints;

public final class SnowflakeIdGenerator
extends AbstractSnowflakeIdGeneratorPaddingRhs
implements IdGenerator {
    public static final int UNUSED_BITS = 1;
    public static final int EPOCH_BITS = 41;
    public static final int MAX_NODE_ID_AND_SEQUENCE_BITS = 22;
    public static final int NODE_ID_BITS_DEFAULT = 10;
    public static final int SEQUENCE_BITS_DEFAULT = 12;
    private final int nodeIdAndSequenceBits;
    private final int sequenceBits;
    private final long maxNodeId;
    private final long maxSequence;
    private final long nodeBits;
    private final long timestampOffsetMs;
    private final EpochClock clock;

    public SnowflakeIdGenerator(int nodeIdBits, int sequenceBits, long nodeId, long timestampOffsetMs, EpochClock clock) {
        if (nodeIdBits < 0) {
            throw new IllegalArgumentException("must be >= 0: nodeIdBits=" + nodeIdBits);
        }
        if (sequenceBits < 0) {
            throw new IllegalArgumentException("must be >= 0: sequenceBits=" + sequenceBits);
        }
        int nodeIdAndSequenceBits = nodeIdBits + sequenceBits;
        if (nodeIdAndSequenceBits > 22) {
            throw new IllegalArgumentException("too many bits used: nodeIdBits=" + nodeIdBits + " + sequenceBits=" + sequenceBits + " > " + 22);
        }
        long maxNodeId = (long)(Math.pow(2.0, nodeIdBits) - 1.0);
        if (nodeId < 0L || nodeId > maxNodeId) {
            throw new IllegalArgumentException("must be >= 0 && <= " + maxNodeId + ": nodeId=" + nodeId);
        }
        if (timestampOffsetMs < 0L) {
            throw new IllegalArgumentException("must be >= 0: timestampOffsetMs=" + timestampOffsetMs);
        }
        long nowMs = clock.time();
        if (timestampOffsetMs > nowMs) {
            throw new IllegalArgumentException("timestampOffsetMs=" + timestampOffsetMs + " > nowMs=" + nowMs);
        }
        this.nodeIdAndSequenceBits = nodeIdAndSequenceBits;
        this.maxNodeId = maxNodeId;
        this.sequenceBits = sequenceBits;
        this.maxSequence = (long)(Math.pow(2.0, sequenceBits) - 1.0);
        this.nodeBits = nodeId << sequenceBits;
        this.timestampOffsetMs = timestampOffsetMs;
        this.clock = clock;
    }

    public SnowflakeIdGenerator(long nodeId) {
        this(10, 12, nodeId, 0L, SystemEpochClock.INSTANCE);
    }

    public long nodeId() {
        return this.nodeBits >>> this.sequenceBits;
    }

    public long timestampOffsetMs() {
        return this.timestampOffsetMs;
    }

    public long maxNodeId() {
        return this.maxNodeId;
    }

    public long maxSequence() {
        return this.maxSequence;
    }

    @Override
    public long nextId() {
        while (true) {
            long oldTimestampMs;
            long oldTimestampSequence = this.timestampSequence;
            long timestampMs = this.clock.time() - this.timestampOffsetMs;
            if (timestampMs > (oldTimestampMs = oldTimestampSequence >>> this.nodeIdAndSequenceBits)) {
                long newTimestampSequence = timestampMs << this.nodeIdAndSequenceBits;
                if (TIMESTAMP_SEQUENCE_UPDATER.compareAndSet(this, oldTimestampSequence, newTimestampSequence)) {
                    return newTimestampSequence | this.nodeBits;
                }
            } else {
                long newTimestampSequence;
                long oldSequence = oldTimestampSequence & this.maxSequence;
                if (oldSequence < this.maxSequence && TIMESTAMP_SEQUENCE_UPDATER.compareAndSet(this, oldTimestampSequence, newTimestampSequence = oldTimestampSequence + 1L)) {
                    return newTimestampSequence | this.nodeBits;
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new IllegalStateException("unexpected thread interrupt");
            }
            ThreadHints.onSpinWait();
        }
    }

    long extractTimestamp(long id) {
        return id >>> this.nodeIdAndSequenceBits;
    }

    long extractNodeId(long id) {
        return id >>> this.sequenceBits & this.maxNodeId;
    }

    long extractSequence(long id) {
        return id & this.maxSequence;
    }
}

