/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona.concurrent.status;

import java.nio.ByteBuffer;
import org.projectnessie.cel.relocated.org.agrona.UnsafeAccess;
import org.projectnessie.cel.relocated.org.agrona.concurrent.AtomicBuffer;
import org.projectnessie.cel.relocated.org.agrona.concurrent.status.CountersManager;
import org.projectnessie.cel.relocated.org.agrona.concurrent.status.StatusIndicator;

public class UnsafeBufferStatusIndicator
extends StatusIndicator {
    private final int counterId;
    private final long addressOffset;
    private final byte[] byteArray;
    private final ByteBuffer byteBuffer;

    public UnsafeBufferStatusIndicator(AtomicBuffer buffer, int counterId) {
        this.counterId = counterId;
        this.byteArray = buffer.byteArray();
        this.byteBuffer = buffer.byteBuffer();
        int counterOffset = CountersManager.counterOffset(counterId);
        buffer.boundsCheck(counterOffset, 8);
        this.addressOffset = buffer.addressOffset() + (long)counterOffset;
    }

    @Override
    public int id() {
        return this.counterId;
    }

    @Override
    public void setOrdered(long value) {
        UnsafeAccess.UNSAFE.putOrderedLong(this.byteArray, this.addressOffset, value);
    }

    @Override
    public long getVolatile() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this.byteArray, this.addressOffset);
    }

    public String toString() {
        return "UnsafeBufferStatusIndicator{counterId=" + this.counterId + "value=" + this.getVolatile() + '}';
    }
}

