/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.projectnessie.cel.Ast;
import org.projectnessie.cel.Env;
import org.projectnessie.cel.EnvOption;
import org.projectnessie.cel.EvalOption;
import org.projectnessie.cel.Library;
import org.projectnessie.cel.Program;
import org.projectnessie.cel.ProgramOption;
import org.projectnessie.cel.common.types.pb.ProtoTypeRegistry;
import org.projectnessie.cel.common.types.ref.TypeRegistry;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Decl;
import org.projectnessie.cel.relocated.com.google.protobuf.Message;
import org.projectnessie.cel.tools.Script;
import org.projectnessie.cel.tools.ScriptCreateException;
import org.projectnessie.cel.tools.ScriptException;

public final class ScriptHost {
    private final boolean disableOptimize;
    private final TypeRegistry registry;

    private ScriptHost(boolean disableOptimize, TypeRegistry registry) {
        this.disableOptimize = disableOptimize;
        this.registry = registry;
    }

    @Deprecated
    public Script getOrCreateScript(String sourceText, List<Decl> declarations, List<Object> types) throws ScriptException {
        return this.buildScript(sourceText).withDeclarations(declarations).withTypes(types).build();
    }

    public ScriptBuilder buildScript(String sourceText) {
        if (sourceText.trim().isEmpty()) {
            throw new IllegalArgumentException("No source code.");
        }
        return new ScriptBuilder(sourceText);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public final class ScriptBuilder {
        private final String sourceText;
        private String container;
        private final List<Decl> declarations = new ArrayList<Decl>();
        private final List<Object> types = new ArrayList<Object>();
        private final List<Library> libraries = new ArrayList<Library>();

        private ScriptBuilder(String sourceText) {
            this.sourceText = sourceText;
        }

        public ScriptBuilder withContainer(String container) {
            this.container = container;
            return this;
        }

        public ScriptBuilder withDeclarations(Decl ... declarations) {
            return this.withDeclarations(Arrays.asList(declarations));
        }

        public ScriptBuilder withDeclarations(List<Decl> declarations) {
            this.declarations.addAll(declarations);
            return this;
        }

        public ScriptBuilder withTypes(Object ... types) {
            return this.withTypes(Arrays.asList(types));
        }

        public ScriptBuilder withTypes(List<Object> types) {
            this.types.addAll(types);
            return this;
        }

        public ScriptBuilder withLibraries(Library ... libraries) {
            return this.withLibraries(Arrays.asList(libraries));
        }

        public ScriptBuilder withLibraries(List<Library> libraries) {
            this.libraries.addAll(libraries);
            return this;
        }

        public Script build() throws ScriptCreateException {
            ArrayList<EnvOption> envOptions = new ArrayList<EnvOption>();
            envOptions.add(Library.StdLib());
            envOptions.add(EnvOption.declarations(this.declarations));
            envOptions.add(EnvOption.types(this.types));
            if (this.container != null) {
                envOptions.add(EnvOption.container(this.container));
            }
            envOptions.addAll(this.libraries.stream().map(Library::Lib).collect(Collectors.toList()));
            Env env = Env.newCustomEnv(ScriptHost.this.registry, envOptions);
            Env.AstIssuesTuple astIss = env.parse(this.sourceText);
            if (astIss.hasIssues()) {
                throw new ScriptCreateException("parse failed", astIss.getIssues());
            }
            Ast ast = astIss.getAst();
            if ((astIss = env.check(ast)).hasIssues()) {
                throw new ScriptCreateException("check failed", astIss.getIssues());
            }
            ArrayList<ProgramOption> programOptions = new ArrayList<ProgramOption>();
            if (!ScriptHost.this.disableOptimize) {
                programOptions.add(ProgramOption.evalOptions(EvalOption.OptOptimize));
            }
            Program prg = env.program(ast, programOptions.toArray(new ProgramOption[0]));
            return new Script(env, prg);
        }
    }

    public static final class Builder {
        private boolean disableOptimize;
        private TypeRegistry registry;

        private Builder() {
        }

        public Builder disableOptimize() {
            this.disableOptimize = true;
            return this;
        }

        public Builder registry(TypeRegistry registry) {
            this.registry = registry;
            return this;
        }

        public ScriptHost build() {
            TypeRegistry r = this.registry;
            if (r == null) {
                r = ProtoTypeRegistry.newRegistry(new Message[0]);
            }
            return new ScriptHost(this.disableOptimize, r);
        }
    }
}

