/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.utils;

import com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.protobuf.cloud.events.v1.EventsMetadata;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuthUtils.class);
    public static final String SEQUENCE_ID_STRING_HEADER_KEY = "_sequence_id";
    public static final String EVENTS_METADATA_HEADER_KEY = "eventsmetadata";

    public static String getBrokerSessionUuid(Map<String, ?> configs) {
        Object uuidConfigValue = configs.get("broker.session.uuid");
        if (uuidConfigValue == null) {
            throw new ConfigException("broker.session.uuid is not set");
        }
        return uuidConfigValue.toString();
    }

    static Long tryParseEventsSequenceIdFromProto(byte[] headerValue) {
        Long sequenceId = null;
        try {
            EventsMetadata em = EventsMetadata.parseFrom((byte[])headerValue);
            sequenceId = AuthUtils.clampSequenceId(em.getSequenceId());
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Error when parsing EventsMetadata protobuf", (Throwable)e);
        }
        return sequenceId;
    }

    static Long tryParseEventsSequenceIdFromString(byte[] headerValue) {
        Objects.requireNonNull(headerValue, "This method shouldn't be used for testing header's existance. headerValue mustn't be null");
        Long sequenceId = null;
        try {
            sequenceId = AuthUtils.clampSequenceId(Long.parseUnsignedLong(new String(headerValue, StandardCharsets.UTF_8)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sequenceId;
    }

    static Long clampSequenceId(Long sequenceId) {
        if (sequenceId <= 0L) {
            LOG.error("Encountered sequence id outside the expected range 0 < {} < 2^63", (Object)Long.toUnsignedString(sequenceId));
            sequenceId = null;
        }
        return sequenceId;
    }

    private static void logResult(String headerName, String key, Long sequenceId) {
        if (sequenceId == null) {
            LOG.error("For message with key {}, unable to read sequence id from {}", (Object)key, (Object)headerName);
        } else {
            LOG.trace("For message with key {}, read sequence id {} from {}", new Object[]{key, sequenceId, headerName});
        }
    }

    public static Long tryParseEventsSequenceId(ConsumerRecord<?, ?> record) {
        Long sequenceId = null;
        Headers headers = record.headers();
        Header protoHeader = headers.lastHeader(EVENTS_METADATA_HEADER_KEY);
        if (protoHeader != null) {
            sequenceId = AuthUtils.tryParseEventsSequenceIdFromProto(protoHeader.value());
            AuthUtils.logResult(EVENTS_METADATA_HEADER_KEY, record.key().toString(), sequenceId);
        } else {
            Header stringHeader = headers.lastHeader(SEQUENCE_ID_STRING_HEADER_KEY);
            if (stringHeader != null) {
                sequenceId = AuthUtils.tryParseEventsSequenceIdFromString(stringHeader.value());
                AuthUtils.logResult(EVENTS_METADATA_HEADER_KEY, record.key().toString(), sequenceId);
            }
        }
        return sequenceId;
    }
}

