/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.metadata;

import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourcePatternFilter;
import io.confluent.security.authorizer.Scope;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;

public interface AuthWriter {
    public CompletionStage<Void> addClusterRoleBinding(Optional<KafkaPrincipal> var1, KafkaPrincipal var2, String var3, Scope var4, String var5);

    default public CompletionStage<Void> addClusterRoleBinding(KafkaPrincipal principal, String role, Scope scope) {
        return this.addClusterRoleBinding(Optional.empty(), principal, role, scope, null);
    }

    public CompletionStage<Void> addResourceRoleBinding(Optional<KafkaPrincipal> var1, KafkaPrincipal var2, String var3, Scope var4, Collection<ResourcePattern> var5, String var6);

    default public CompletionStage<Void> addResourceRoleBinding(KafkaPrincipal principal, String role, Scope scope, Collection<ResourcePattern> resources) {
        return this.addResourceRoleBinding(Optional.empty(), principal, role, scope, resources, null);
    }

    public CompletionStage<Void> removeRoleBinding(Optional<KafkaPrincipal> var1, KafkaPrincipal var2, String var3, Scope var4, String var5);

    default public CompletionStage<Void> removeRoleBinding(KafkaPrincipal principal, String role, Scope scope) {
        return this.removeRoleBinding(Optional.empty(), principal, role, scope, null);
    }

    public CompletionStage<Void> removeResourceRoleBinding(Optional<KafkaPrincipal> var1, KafkaPrincipal var2, String var3, Scope var4, Collection<ResourcePatternFilter> var5, String var6);

    default public CompletionStage<Void> removeResourceRoleBinding(KafkaPrincipal principal, String role, Scope scope, Collection<ResourcePatternFilter> resources) {
        return this.removeResourceRoleBinding(Optional.empty(), principal, role, scope, resources, null);
    }

    public CompletionStage<Void> replaceResourceRoleBinding(Optional<KafkaPrincipal> var1, KafkaPrincipal var2, String var3, Scope var4, Collection<ResourcePattern> var5, String var6);

    default public CompletionStage<Void> replaceResourceRoleBinding(KafkaPrincipal principal, String role, Scope scope, Collection<ResourcePattern> resources) {
        return this.replaceResourceRoleBinding(Optional.empty(), principal, role, scope, resources, null);
    }

    public CompletionStage<Void> createAcls(Optional<KafkaPrincipal> var1, Scope var2, AclBinding var3);

    default public CompletionStage<Void> createAcls(Scope scope, AclBinding aclBinding) {
        return this.createAcls(Optional.empty(), scope, aclBinding);
    }

    public Map<AclBinding, CompletionStage<AclCreateResult>> createAcls(Optional<KafkaPrincipal> var1, Scope var2, List<AclBinding> var3);

    default public Map<AclBinding, CompletionStage<AclCreateResult>> createAcls(Scope scope, List<AclBinding> aclBindings) {
        return this.createAcls(Optional.empty(), scope, aclBindings);
    }

    public CompletionStage<Collection<AclBinding>> deleteAcls(Optional<KafkaPrincipal> var1, Scope var2, AclBindingFilter var3, Predicate<ResourcePattern> var4);

    default public CompletionStage<Collection<AclBinding>> deleteAcls(Scope scope, AclBindingFilter aclBindingFilter, Predicate<ResourcePattern> resourceAccess) {
        return this.deleteAcls(Optional.empty(), scope, aclBindingFilter, resourceAccess);
    }

    public Map<AclBindingFilter, CompletionStage<AclDeleteResult>> deleteAcls(Optional<KafkaPrincipal> var1, Scope var2, List<AclBindingFilter> var3, Predicate<ResourcePattern> var4);

    default public Map<AclBindingFilter, CompletionStage<AclDeleteResult>> deleteAcls(Scope scope, List<AclBindingFilter> aclBindingFilters, Predicate<ResourcePattern> resourceAccess) {
        return this.deleteAcls(Optional.empty(), scope, aclBindingFilters, resourceAccess);
    }
}

