/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import java.util.Objects;

@JsonTypeName(value="IdentityProvider")
public class IdentityProviderKey
extends AuthKey {
    private final String orgId;
    private final String providerId;

    public IdentityProviderKey(@JsonProperty(value="orgId") String orgId, @JsonProperty(value="providerId") String providerId) {
        this.orgId = Objects.requireNonNull(orgId, "Argument `orgId` must not be null");
        this.providerId = Objects.requireNonNull(providerId, "Argument `providerId` must not be null");
    }

    @JsonProperty
    public String providerId() {
        return this.providerId;
    }

    @JsonProperty
    public String orgId() {
        return this.orgId;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.IDENTITY_PROVIDER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdentityProviderKey that = (IdentityProviderKey)o;
        return Objects.equals(this.orgId, that.orgId) && Objects.equals(this.providerId, that.providerId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entryType().name(), this.orgId, this.providerId);
    }

    public String toString() {
        return String.format("IdentityProviderKey{\n\torgId=%s\n\tproviderId=%s\n}", this.orgId, this.providerId);
    }
}

