/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthValue;
import java.util.Objects;

public class LatencyRecordValue
extends AuthValue {
    private final long timestamp;

    @JsonCreator
    public LatencyRecordValue(@JsonProperty(value="timestamp") long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.LATENCY_RECORD;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LatencyRecordValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LatencyRecordValue that = (LatencyRecordValue)o;
        return Objects.equals(this.timestamp, that.timestamp);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.timestamp);
    }

    public String toString() {
        return "LatencyRecordValue{timestamp=" + this.timestamp + "}";
    }
}

