/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.license.store;

import io.confluent.license.store.ConfluentLicenseStore;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryLicenseStore
implements ConfluentLicenseStore {
    private static final Logger log = LoggerFactory.getLogger(InMemoryLicenseStore.class);
    private final AtomicBoolean running = new AtomicBoolean();
    private LinkedList<String> inMemoryCache;

    @Override
    public void start() {
        if (this.running.compareAndSet(false, true)) {
            log.info("Starting License Store");
            this.startInMemoryCache();
            log.info("Started License Store");
        }
    }

    private void startInMemoryCache() {
        this.inMemoryCache = new LinkedList();
    }

    @Override
    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            log.info("Closing License Store");
            this.stopInMemoryCache();
            log.info("Closed License Store");
        }
    }

    private void stopInMemoryCache() {
        this.inMemoryCache = null;
    }

    @Override
    public String licenseScan() {
        try {
            return !this.inMemoryCache.isEmpty() ? this.inMemoryCache.getLast() : "";
        }
        catch (NullPointerException | NoSuchElementException e) {
            log.error("Failed to read license from InMemory Store: ", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void registerLicense(String license) {
        if (this.inMemoryCache != null) {
            this.inMemoryCache.addLast(license);
        }
    }
}

