/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.license.util;

import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stage {
    private static final Logger log = LoggerFactory.getLogger(Stage.class);
    private final String description;
    private final long started;
    private volatile Long completed;

    public Stage(String description, long started) {
        this.description = description;
        this.started = started;
        this.completed = null;
    }

    public String description() {
        return this.description;
    }

    public long started() {
        return this.started;
    }

    public Long completed() {
        return this.completed;
    }

    public synchronized void complete(long time) {
        if (time < this.started) {
            log.warn("Ignoring invalid completion time {} since it is before this stage's start time of {}", (Object)time, (Object)this.started);
            return;
        }
        if (this.completed != null) {
            log.warn("Ignoring completion time of {} since this stage was already completed at {}", (Object)time, (Object)this.completed);
            return;
        }
        this.completed = time;
    }

    public String summarize() {
        Long completed = this.completed;
        if (completed != null) {
            return "The last operation the worker completed was " + this.description() + ", which began at " + String.valueOf(Instant.ofEpochMilli(this.started())) + " and completed at " + String.valueOf(Instant.ofEpochMilli(this.completed())) + ".";
        }
        return "The worker is currently " + this.description() + ", which began at " + String.valueOf(Instant.ofEpochMilli(this.started())) + ".";
    }

    public String toString() {
        return this.description + "(started " + this.started + ", completed=" + this.completed() + ")";
    }
}

