/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class EnumRecommender<T extends Enum<T>>
implements ConfigDef.Validator,
ConfigDef.Recommender {
    private final Set<String> validValues;
    private final Class<T> enumClass;

    public EnumRecommender(Class<T> enumClass, Function<String, String> conversion, T ... excludedValues) {
        String key;
        this.enumClass = enumClass;
        LinkedHashSet<String> validEnums = new LinkedHashSet<String>();
        for (Enum o : (Enum[])enumClass.getEnumConstants()) {
            key = conversion.apply(o.toString());
            validEnums.add(key);
        }
        for (Enum excluded : excludedValues) {
            key = conversion.apply(excluded.toString());
            validEnums.remove(key);
        }
        this.validValues = ImmutableSet.copyOf(validEnums);
    }

    public void ensureValid(String key, Object value) {
        if (value != null && !this.validValues.contains(value.toString())) {
            throw new ConfigException(key, value, "Invalid enumerator");
        }
    }

    public String toString() {
        return this.validValues.toString();
    }

    public List<Object> validValues(String name, Map<String, Object> connectorConfigs) {
        return ImmutableList.copyOf(this.validValues);
    }

    public boolean visible(String name, Map<String, Object> connectorConfigs) {
        return true;
    }
}

