/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.utils;

import io.kcache.CheckpointHandler;
import io.kcache.KafkaCacheConfig;
import io.kcache.exceptions.CacheInitializationException;
import io.kcache.utils.OffsetCheckpoint;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCheckpointHandler
implements CheckpointHandler {
    private static final Logger log = LoggerFactory.getLogger(FileCheckpointHandler.class);
    private String topic;
    private String checkpointDir;
    private int checkpointVersion;
    private OffsetCheckpoint checkpointFile;
    private final Map<TopicPartition, Long> checkpointFileCache = new HashMap<TopicPartition, Long>();

    @Override
    public void configure(Map<String, ?> configs) {
        KafkaCacheConfig config = new KafkaCacheConfig(configs);
        this.topic = config.getString("kafkacache.topic");
        this.checkpointDir = config.getString("kafkacache.checkpoint.dir");
        this.checkpointVersion = config.getInt("kafkacache.checkpoint.version");
    }

    @Override
    public void init() throws CacheInitializationException {
        try {
            this.checkpointFile = new OffsetCheckpoint(this.checkpointDir, this.checkpointVersion, this.topic);
            this.checkpointFileCache.putAll(this.checkpointFile.read());
        }
        catch (IOException e) {
            throw new CacheInitializationException("Failed to read checkpoints", e);
        }
    }

    @Override
    public Map<TopicPartition, Long> checkpoints() {
        return new HashMap<TopicPartition, Long>(this.checkpointFileCache);
    }

    @Override
    public void updateCheckpoints(Map<TopicPartition, Long> checkpoints) throws IOException {
        this.checkpointFileCache.putAll(checkpoints);
        this.checkpointFile.write(this.checkpointFileCache);
    }

    @Override
    public void close() throws IOException {
        if (this.checkpointFile != null) {
            this.checkpointFile.close();
        }
    }
}

