/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.utils;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShutdownableThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ShutdownableThread.class);
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);

    public ShutdownableThread(String name) {
        super(name);
        this.setDaemon(false);
    }

    public void shutdown() throws InterruptedException {
        if (this.initiateShutdown()) {
            this.awaitShutdown();
        }
    }

    protected boolean initiateShutdown() {
        return this.isRunning.getAndSet(false);
    }

    protected void awaitShutdown() throws InterruptedException {
        this.shutdownLatch.await();
        log.info("Shutdown completed");
    }

    protected abstract void doWork();

    @Override
    public void run() {
        log.info("Starting");
        try {
            while (this.isRunning()) {
                this.doWork();
            }
        }
        catch (Error | RuntimeException e) {
            log.error("Thread {} exiting with uncaught exception: ", (Object)this.getName(), (Object)e);
            throw e;
        }
        finally {
            this.shutdownLatch.countDown();
        }
        log.info("Stopped");
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }
}

