/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AggregateFunctionInitArguments {
    public static final AggregateFunctionInitArguments EMPTY_ARGS = new AggregateFunctionInitArguments();
    private final ImmutableList<Integer> udafIndices;
    private final List<Object> initArgs;
    private final ImmutableMap<String, ?> config;

    public AggregateFunctionInitArguments(List<Integer> indices, Object ... initArgs) {
        this(indices, (Map<String, ?>)ImmutableMap.of(), Arrays.asList(initArgs));
    }

    public AggregateFunctionInitArguments(List<Integer> indices, Map<String, ?> config, Object ... initArgs) {
        this(indices, config, Arrays.asList(initArgs));
    }

    public AggregateFunctionInitArguments(List<Integer> indices, Map<String, ?> config, List<Object> initArgs) {
        this.udafIndices = ImmutableList.copyOf(indices);
        this.config = ImmutableMap.copyOf(Objects.requireNonNull(config, "config"));
        this.initArgs = new ArrayList<Object>((Collection)Objects.requireNonNull(initArgs, "initArgs"));
        Optional<Integer> negativeIndex = indices.stream().filter(index -> index < 0).findFirst();
        if (negativeIndex.isPresent()) {
            throw new IllegalArgumentException("index is negative: " + String.valueOf(negativeIndex.get()));
        }
    }

    private AggregateFunctionInitArguments() {
        this.udafIndices = ImmutableList.of((Object)0);
        this.config = ImmutableMap.of();
        this.initArgs = ImmutableList.of();
    }

    public List<Integer> udafIndices() {
        return this.udafIndices;
    }

    public Object arg(int i) {
        return this.initArgs.get(i);
    }

    public List<Object> args() {
        return Collections.unmodifiableList(this.initArgs);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="config is ImmutableMap")
    public Map<String, ?> config() {
        return this.config;
    }
}

