/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.types;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.function.types.ObjectType;
import io.confluent.ksql.function.types.ParamType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class LambdaType
extends ObjectType {
    private final ImmutableList<ParamType> inputTypes;
    private final ParamType returnType;

    private LambdaType(List<ParamType> inputTypes, ParamType returnType) {
        this.inputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputTypes, "inputTypes"));
        this.returnType = Objects.requireNonNull(returnType, "returnType");
    }

    public static LambdaType of(List<ParamType> inputTypes, ParamType returnType) {
        return new LambdaType(inputTypes, returnType);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="inputTypes is ImmutableList")
    public List<ParamType> inputTypes() {
        return this.inputTypes;
    }

    public ParamType returnType() {
        return this.returnType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaType lambdaType = (LambdaType)o;
        return Objects.equals(this.inputTypes, lambdaType.inputTypes) && Objects.equals(this.returnType, lambdaType.returnType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.inputTypes, this.returnType);
    }

    @Override
    public String toString() {
        return "LAMBDA " + this.inputTypes.stream().map(Object::toString).collect(Collectors.joining(", ", "(", ")")) + " => " + String.valueOf(this.returnType);
    }
}

