/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.types;

import io.confluent.ksql.function.types.AnyType;
import io.confluent.ksql.function.types.ArrayType;
import io.confluent.ksql.function.types.BooleanType;
import io.confluent.ksql.function.types.BytesType;
import io.confluent.ksql.function.types.DateType;
import io.confluent.ksql.function.types.DecimalType;
import io.confluent.ksql.function.types.DoubleType;
import io.confluent.ksql.function.types.IntegerType;
import io.confluent.ksql.function.types.IntervalUnitType;
import io.confluent.ksql.function.types.LambdaType;
import io.confluent.ksql.function.types.LongType;
import io.confluent.ksql.function.types.MapType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.types.StringType;
import io.confluent.ksql.function.types.StructType;
import io.confluent.ksql.function.types.TimeType;
import io.confluent.ksql.function.types.TimestampType;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlLambda;
import io.confluent.ksql.schema.ksql.types.SqlLambdaResolved;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.Map;
import java.util.Optional;

public final class ParamTypes {
    public static final BooleanType BOOLEAN = BooleanType.INSTANCE;
    public static final IntegerType INTEGER = IntegerType.INSTANCE;
    public static final DoubleType DOUBLE = DoubleType.INSTANCE;
    public static final StringType STRING = StringType.INSTANCE;
    public static final LongType LONG = LongType.INSTANCE;
    public static final ParamType DECIMAL = DecimalType.INSTANCE;
    public static final TimeType TIME = TimeType.INSTANCE;
    public static final DateType DATE = DateType.INSTANCE;
    public static final TimestampType TIMESTAMP = TimestampType.INSTANCE;
    public static final IntervalUnitType INTERVALUNIT = IntervalUnitType.INSTANCE;
    public static final BytesType BYTES = BytesType.INSTANCE;
    public static final AnyType ANY = AnyType.INSTANCE;

    private ParamTypes() {
    }

    public static boolean areCompatible(SqlArgument actual, ParamType declared) {
        return ParamTypes.areCompatible(actual, declared, false);
    }

    public static boolean areCompatible(SqlArgument argument, ParamType declared, boolean allowCast) {
        if (declared instanceof AnyType) {
            return true;
        }
        Optional sqlLambdaOptional = argument.getSqlLambda();
        if (sqlLambdaOptional.isPresent() && declared instanceof LambdaType) {
            LambdaType declaredLambda = (LambdaType)declared;
            SqlLambda sqlLambda = (SqlLambda)sqlLambdaOptional.get();
            if (sqlLambda instanceof SqlLambdaResolved) {
                SqlLambdaResolved sqlLambdaResolved = (SqlLambdaResolved)sqlLambda;
                if (sqlLambdaResolved.getInputType().size() != declaredLambda.inputTypes().size()) {
                    return false;
                }
                int i = 0;
                for (ParamType paramType : declaredLambda.inputTypes()) {
                    if (!ParamTypes.areCompatible(SqlArgument.of((SqlType)((SqlType)sqlLambdaResolved.getInputType().get(i))), paramType, allowCast)) {
                        return false;
                    }
                    ++i;
                }
                return ParamTypes.areCompatible(SqlArgument.of((SqlType)sqlLambdaResolved.getReturnType()), declaredLambda.returnType(), allowCast);
            }
            return sqlLambda.getNumInputs().intValue() == declaredLambda.inputTypes().size();
        }
        if (argument.getSqlIntervalUnit().isPresent() && declared instanceof IntervalUnitType) {
            return true;
        }
        if (argument.getSqlIntervalUnit().isPresent() || declared instanceof IntervalUnitType) {
            return false;
        }
        SqlType argumentSqlType = argument.getSqlTypeOrThrow();
        if (argumentSqlType.baseType() == SqlBaseType.ARRAY && declared instanceof ArrayType) {
            return ParamTypes.areCompatible(SqlArgument.of((SqlType)((SqlArray)argumentSqlType).getItemType()), ((ArrayType)declared).element(), allowCast);
        }
        if (argumentSqlType.baseType() == SqlBaseType.MAP && declared instanceof MapType) {
            SqlMap sqlType = (SqlMap)argumentSqlType;
            MapType mapType = (MapType)declared;
            return ParamTypes.areCompatible(SqlArgument.of((SqlType)sqlType.getKeyType()), mapType.key(), allowCast) && ParamTypes.areCompatible(SqlArgument.of((SqlType)sqlType.getValueType()), mapType.value(), allowCast);
        }
        if (argumentSqlType.baseType() == SqlBaseType.STRUCT && declared instanceof StructType) {
            return ParamTypes.isStructCompatible(argumentSqlType, declared);
        }
        return ParamTypes.isPrimitiveMatch(argumentSqlType, declared, allowCast);
    }

    private static boolean isStructCompatible(SqlType actual, ParamType declared) {
        SqlStruct actualStruct = (SqlStruct)actual;
        if (actualStruct.fields().isEmpty() || ((StructType)declared).getSchema().isEmpty()) {
            return true;
        }
        for (Map.Entry<String, ParamType> entry : ((StructType)declared).getSchema().entrySet()) {
            String k = entry.getKey();
            Optional field = actualStruct.field(k);
            if (field.isPresent() && ParamTypes.areCompatible(SqlArgument.of((SqlType)((SqlStruct.Field)field.get()).type()), entry.getValue(), false)) continue;
            return false;
        }
        return actualStruct.fields().size() == ((StructType)declared).getSchema().size();
    }

    private static boolean isPrimitiveMatch(SqlType actual, ParamType declared, boolean allowCast) {
        SqlBaseType base = actual.baseType();
        return base == SqlBaseType.STRING && declared instanceof StringType || base == SqlBaseType.INTEGER && declared instanceof IntegerType || base == SqlBaseType.BIGINT && declared instanceof LongType || base == SqlBaseType.BOOLEAN && declared instanceof BooleanType || base == SqlBaseType.DOUBLE && declared instanceof DoubleType || base == SqlBaseType.DECIMAL && declared instanceof DecimalType || base == SqlBaseType.TIME && declared instanceof TimeType || base == SqlBaseType.DATE && declared instanceof DateType || base == SqlBaseType.TIMESTAMP && declared instanceof TimestampType || base == SqlBaseType.BYTES && declared instanceof BytesType || allowCast && base.canImplicitlyCast(SchemaConverters.functionToSqlBaseConverter().toBaseType(declared));
    }
}

