/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.types;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.function.types.ObjectType;
import io.confluent.ksql.function.types.ParamType;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class StructType
extends ObjectType {
    public static final StructType ANY_STRUCT = StructType.builder().build();
    private final ImmutableMap<String, ParamType> schema;

    private StructType(Map<String, ParamType> schema) {
        this.schema = ImmutableMap.copyOf(Objects.requireNonNull(schema, "schema"));
    }

    public static Builder builder() {
        return new Builder();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="schema is ImmutableMap")
    public Map<String, ParamType> getSchema() {
        return this.schema;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructType that = (StructType)o;
        return Objects.equals(this.schema, that.schema);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.schema);
    }

    @Override
    public String toString() {
        return "STRUCT<" + this.schema.entrySet().stream().map(e -> (String)e.getKey() + " " + String.valueOf(e.getValue())).collect(Collectors.joining(", ")) + ">";
    }

    public static final class Builder {
        private final ImmutableMap.Builder<String, ParamType> builder = new ImmutableMap.Builder();

        private Builder() {
        }

        public Builder field(String name, ParamType value) {
            this.builder.put((Object)name, (Object)value);
            return this;
        }

        public StructType build() {
            return new StructType((Map<String, ParamType>)this.builder.build());
        }
    }
}

