/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logging.processing;

import io.confluent.ksql.logging.processing.MeteredProcessingLogger;
import io.confluent.ksql.logging.processing.ProcessingLogConfig;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.ProcessingLoggerFactory;
import io.confluent.ksql.logging.processing.ProcessingLoggerImpl;
import io.confluent.ksql.util.MetricsTagsUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MeteredProcessingLoggerFactory
implements ProcessingLoggerFactory {
    public static final String PROCESSING_LOG_ERROR_METRIC_NAME = "processing-error-total";
    public static final String PROCESSING_LOG_METRICS_GROUP_NAME = "processing-diagnostic-metrics";
    public static final String PROCESSING_LOG_METRIC_DESCRIPTION = "The total number of errors emitted by the processing log.";
    private final ProcessingLogConfig config;
    private final Metrics metrics;
    private final Map<String, String> metricsTags;
    private final BiFunction<ProcessingLogConfig, Logger, ProcessingLogger> loggerFactory;
    private final Function<Metrics, BiFunction<ProcessingLogger, Sensor, ProcessingLogger>> loggerWithMetricsFactory;
    private final Map<String, ProcessingLogger> processingLoggers;

    MeteredProcessingLoggerFactory(ProcessingLogConfig config, Metrics metrics, Map<String, String> metricsTags) {
        this(config, metrics, ProcessingLoggerImpl::new, metricObject -> (processingLogger, sensor) -> new MeteredProcessingLogger((ProcessingLogger)processingLogger, (Metrics)metricObject, (Sensor)sensor), metricsTags);
    }

    MeteredProcessingLoggerFactory(ProcessingLogConfig config, Metrics metrics, BiFunction<ProcessingLogConfig, Logger, ProcessingLogger> loggerFactory, Function<Metrics, BiFunction<ProcessingLogger, Sensor, ProcessingLogger>> loggerWithMetricsFactory, Map<String, String> metricsTags) {
        this.config = config;
        this.metrics = metrics;
        this.loggerFactory = loggerFactory;
        this.loggerWithMetricsFactory = loggerWithMetricsFactory;
        this.metricsTags = metricsTags;
        this.processingLoggers = new HashMap<String, ProcessingLogger>();
    }

    @Override
    public ProcessingLogger getLogger(String name) {
        return this.getLogger(name, Collections.emptyMap());
    }

    @Override
    public synchronized ProcessingLogger getLogger(String name, Map<String, String> additionalTags) {
        if (this.processingLoggers.containsKey(name)) {
            return this.processingLoggers.get(name);
        }
        Sensor errorSensor = null;
        if (this.metrics != null) {
            HashMap<String, String> combinedMetricsTags = new HashMap<String, String>(additionalTags);
            combinedMetricsTags.putAll(this.metricsTags);
            errorSensor = MeteredProcessingLoggerFactory.configureProcessingErrorSensor(this.metrics, combinedMetricsTags, name);
        }
        ProcessingLogger meteredProcessingLogger = this.loggerWithMetricsFactory.apply(this.metrics).apply(this.getProcessLogger(name), errorSensor);
        this.processingLoggers.put(name, meteredProcessingLogger);
        return meteredProcessingLogger;
    }

    @Override
    public synchronized Collection<ProcessingLogger> getLoggers() {
        return this.processingLoggers.values();
    }

    @Override
    public synchronized Collection<ProcessingLogger> getLoggersWithPrefix(String prefix) {
        return this.processingLoggers.keySet().stream().filter(loggerName -> loggerName.startsWith(prefix)).map(this.processingLoggers::get).collect(Collectors.toList());
    }

    private static Sensor configureProcessingErrorSensor(Metrics metrics, Map<String, String> metricsTags, String loggerName) {
        Map<String, String> metricsTagsWithLoggerId = MetricsTagsUtil.getMetricsTagsWithLoggerId(loggerName, metricsTags);
        MetricName errorMetric = metrics.metricName(PROCESSING_LOG_ERROR_METRIC_NAME, PROCESSING_LOG_METRICS_GROUP_NAME, PROCESSING_LOG_METRIC_DESCRIPTION, metricsTagsWithLoggerId);
        Sensor sensor = metrics.sensor(loggerName);
        sensor.add(errorMetric, (MeasurableStat)new CumulativeSum());
        return sensor;
    }

    private ProcessingLogger getProcessLogger(String name) {
        String loggerName = String.join((CharSequence)".", "processing", name);
        Logger logger = LogManager.getLogger((String)loggerName);
        return this.loggerFactory.apply(this.config, logger);
    }
}

