/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logging.processing;

import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public final class ProcessingLogMessageSchema {
    private static final String NAMESPACE = "io.confluent.ksql.logging.processing.";
    private static final Schema CAUSE_SCHEMA = SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build();
    public static final String DESERIALIZATION_ERROR_FIELD_TARGET = "target";
    public static final String DESERIALIZATION_ERROR_FIELD_MESSAGE = "errorMessage";
    public static final String DESERIALIZATION_ERROR_FIELD_RECORD_B64 = "recordB64";
    public static final String DESERIALIZATION_ERROR_FIELD_CAUSE = "cause";
    public static final String DESERIALIZATION_ERROR_FIELD_TOPIC = "topic";
    private static final Schema DESERIALIZATION_ERROR_SCHEMA = SchemaBuilder.struct().name("io.confluent.ksql.logging.processing.DeserializationError").field("target", Schema.OPTIONAL_STRING_SCHEMA).field("errorMessage", Schema.OPTIONAL_STRING_SCHEMA).field("recordB64", Schema.OPTIONAL_STRING_SCHEMA).field("cause", CAUSE_SCHEMA).field("topic", Schema.OPTIONAL_STRING_SCHEMA).optional().build();
    public static final String RECORD_PROCESSING_ERROR_FIELD_MESSAGE = "errorMessage";
    public static final String RECORD_PROCESSING_ERROR_FIELD_RECORD = "record";
    public static final String RECORD_PROCESSING_ERROR_FIELD_CAUSE = "cause";
    private static final Schema RECORD_PROCESSING_ERROR_SCHEMA = SchemaBuilder.struct().name("io.confluent.ksql.logging.processing.RecordProcessingError").field("errorMessage", Schema.OPTIONAL_STRING_SCHEMA).field("record", Schema.OPTIONAL_STRING_SCHEMA).field("cause", CAUSE_SCHEMA).optional().build();
    public static final String PRODUCTION_ERROR_FIELD_MESSAGE = "errorMessage";
    private static final Schema PRODUCTION_ERROR_SCHEMA = SchemaBuilder.struct().name("io.confluent.ksql.logging.processing.ProductionError").field("errorMessage", Schema.OPTIONAL_STRING_SCHEMA).optional().build();
    public static final String SERIALIZATION_ERROR_FIELD_TARGET = "target";
    public static final String SERIALIZATION_ERROR_FIELD_MESSAGE = "errorMessage";
    public static final String SERIALIZATION_ERROR_FIELD_RECORD = "record";
    public static final String SERIALIZATION_ERROR_FIELD_CAUSE = "cause";
    public static final String SERIALIZATION_ERROR_FIELD_TOPIC = "topic";
    private static final Schema SERIALIZATION_ERROR_SCHEMA = SchemaBuilder.struct().name("io.confluent.ksql.logging.processing.SerializationError").field("target", Schema.OPTIONAL_STRING_SCHEMA).field("errorMessage", Schema.OPTIONAL_STRING_SCHEMA).field("record", Schema.OPTIONAL_STRING_SCHEMA).field("cause", CAUSE_SCHEMA).field("topic", Schema.OPTIONAL_STRING_SCHEMA).optional().build();
    public static final String KAFKA_STREAMS_THREAD_ERROR_FIELD_MESSAGE = "errorMessage";
    public static final String KAFKA_STREAMS_THREAD_ERROR_FIELD_NAME = "threadName";
    public static final String KAFKA_STREAMS_THREAD_ERROR_FIELD_CAUSE = "cause";
    private static final Schema KAFKA_STREAMS_THREAD_ERROR_SCHEMA = SchemaBuilder.struct().name("io.confluent.ksql.logging.processing.KafkaStreamsThreadError").field("errorMessage", Schema.OPTIONAL_STRING_SCHEMA).field("threadName", Schema.OPTIONAL_STRING_SCHEMA).field("cause", CAUSE_SCHEMA).optional().build();
    public static final String TYPE = "type";
    public static final String DESERIALIZATION_ERROR = "deserializationError";
    public static final String RECORD_PROCESSING_ERROR = "recordProcessingError";
    public static final String PRODUCTION_ERROR = "productionError";
    public static final String SERIALIZATION_ERROR = "serializationError";
    public static final String KAFKA_STREAMS_THREAD_ERROR = "kafkaStreamsThreadError";
    public static final Schema PROCESSING_LOG_SCHEMA = SchemaBuilder.struct().name("io.confluent.ksql.logging.processing.ProcessingLogRecord").field("type", Schema.OPTIONAL_INT32_SCHEMA).field("deserializationError", DESERIALIZATION_ERROR_SCHEMA).field("recordProcessingError", RECORD_PROCESSING_ERROR_SCHEMA).field("productionError", PRODUCTION_ERROR_SCHEMA).field("serializationError", SERIALIZATION_ERROR_SCHEMA).field("kafkaStreamsThreadError", KAFKA_STREAMS_THREAD_ERROR_SCHEMA).optional().build();

    private ProcessingLogMessageSchema() {
    }

    public static enum MessageType {
        DESERIALIZATION_ERROR(0, DESERIALIZATION_ERROR_SCHEMA),
        RECORD_PROCESSING_ERROR(1, RECORD_PROCESSING_ERROR_SCHEMA),
        PRODUCTION_ERROR(2, PRODUCTION_ERROR_SCHEMA),
        SERIALIZATION_ERROR(3, SERIALIZATION_ERROR_SCHEMA),
        KAFKA_STREAMS_THREAD_ERROR(4, KAFKA_STREAMS_THREAD_ERROR_SCHEMA);

        private final int typeId;
        private final Schema schema;

        private MessageType(int typeId, Schema schema) {
            this.typeId = typeId;
            this.schema = schema;
        }

        public int getTypeId() {
            return this.typeId;
        }

        public Schema getSchema() {
            return this.schema;
        }
    }
}

