/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metrics;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.common.utils.Time;
import io.confluent.ksql.metrics.MetricCollector;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.metrics.MetricUtils;
import io.confluent.ksql.metrics.TopicSensors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Rate;

public final class StreamsErrorCollector
implements MetricCollector {
    public static final String CONSUMER_FAILED_MESSAGES = "consumer-failed-messages";
    public static final String CONSUMER_FAILED_MESSAGES_PER_SEC = "consumer-failed-messages-per-sec";
    private final MetricCollectors metricCollectors;
    private final Metrics metrics;
    private final Map<String, TopicSensors<Object>> topicSensors = Maps.newConcurrentMap();
    private final Time time;
    private String id;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="metrics")
    public static StreamsErrorCollector create(String applicationId, MetricCollectors collectors) {
        StreamsErrorCollector collector = new StreamsErrorCollector(collectors);
        collector.id = collectors.addCollector(applicationId, collector);
        return collector;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="metrics")
    private StreamsErrorCollector(MetricCollectors collectors) {
        this.metricCollectors = collectors;
        this.metrics = collectors.getMetrics();
        this.time = collectors.getTime();
    }

    private TopicSensors<Object> buildSensors(String topic) {
        ArrayList sensors = new ArrayList();
        sensors.add(this.buildSensor(topic, CONSUMER_FAILED_MESSAGES, (MeasurableStat)new CumulativeSum(), o -> 1.0));
        sensors.add(this.buildSensor(topic, CONSUMER_FAILED_MESSAGES_PER_SEC, (MeasurableStat)new Rate(), o -> 1.0));
        return new TopicSensors<Object>(topic, sensors);
    }

    private TopicSensors.SensorMetric<Object> buildSensor(String key, String metricNameString, MeasurableStat stat, final Function<Object, Double> recordValue) {
        String name = "sec-" + key + "-" + metricNameString + "-" + this.id;
        MetricName metricName = new MetricName(metricNameString, "consumer-metrics", "consumer-" + name, (Map)ImmutableMap.of((Object)"key", (Object)key, (Object)"id", (Object)this.id));
        final Sensor sensor = this.metrics.sensor(name);
        sensor.add(metricName, stat);
        KafkaMetric metric = (KafkaMetric)this.metrics.metrics().get(metricName);
        return new TopicSensors.SensorMetric<Object>(sensor, metric, this.time, true){

            @Override
            void record(Object o) {
                sensor.record(((Double)recordValue.apply(o)).doubleValue());
                super.record(o);
            }
        };
    }

    public void cleanup() {
        this.metricCollectors.remove(this.id);
        this.topicSensors.values().forEach(v -> v.close(this.metrics));
    }

    @Override
    public double errorRate() {
        ArrayList allStats = new ArrayList();
        this.topicSensors.values().forEach(record -> allStats.addAll(record.errorRateStats()));
        return allStats.stream().mapToDouble(TopicSensors.Stat::getValue).sum();
    }

    @Override
    public double aggregateStat(String name, boolean isError) {
        return MetricUtils.aggregateStat(name, isError, this.topicSensors.values());
    }

    @Override
    public Collection<TopicSensors.Stat> stats(String topic, boolean isError) {
        return MetricUtils.stats(topic, isError, this.topicSensors.values());
    }

    public void recordError(String topic) {
        this.topicSensors.computeIfAbsent(topic, this::buildSensors).increment(null, true);
    }
}

