/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import com.google.errorprone.annotations.Immutable;
import java.util.Objects;

@Immutable
public final class TokenLocation {
    private final int line;
    private final int charPositionInLine;
    private final int startIndex;
    private final int stopIndex;

    public static TokenLocation of(int line, int charPositionInLine) {
        return new TokenLocation(line, charPositionInLine, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public TokenLocation(int line, int charPositionInLine, int startIndex, int stopIndex) {
        this.line = line;
        this.charPositionInLine = charPositionInLine;
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
    }

    public int getLine() {
        return this.line;
    }

    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getStopIndex() {
        return this.stopIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenLocation that = (TokenLocation)o;
        return this.line == that.line && this.charPositionInLine == that.charPositionInLine && this.startIndex == that.startIndex && this.stopIndex == that.stopIndex;
    }

    public int hashCode() {
        return Objects.hash(this.line, this.charPositionInLine, this.startIndex, this.stopIndex);
    }
}

