/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.properties;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.config.ImmutableProperties;
import io.confluent.ksql.config.PropertyValidator;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class LocalPropertyValidator
implements PropertyValidator {
    private final Set<String> immutableProps;
    private static final Map<String, Consumer<Object>> HANDLERS = ImmutableMap.builder().put((Object)"auto.offset.reset", LocalPropertyValidator::validateConsumerOffsetResetConfig).build();

    LocalPropertyValidator() {
        this(ImmutableProperties.getImmutableProperties());
    }

    LocalPropertyValidator(Collection<String> immutableProps) {
        this.immutableProps = ImmutableSet.copyOf(Objects.requireNonNull(immutableProps, "immutableProps"));
    }

    @Override
    public void validate(String name, Object value) {
        if (this.immutableProps.contains(name)) {
            throw new IllegalArgumentException(String.format("Cannot override property '%s'", name));
        }
        Consumer<Object> validator = HANDLERS.get(name);
        if (validator != null) {
            validator.accept(value);
        }
    }

    private static void validateConsumerOffsetResetConfig(Object value) {
        if (value instanceof String && "none".equalsIgnoreCase((String)value)) {
            throw new IllegalArgumentException("'none' is not valid for this property within KSQL");
        }
    }
}

