/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.reactive;

import io.confluent.ksql.reactive.BasePublisher;
import io.vertx.core.Context;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import java.util.Queue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferedPublisher<T>
extends BasePublisher<T> {
    private static final Logger log = LogManager.getLogger(BufferedPublisher.class);
    public static final int SEND_MAX_BATCH_SIZE = 200;
    public static final int DEFAULT_BUFFER_MAX_SIZE = 200;
    private final Queue<T> buffer = new ArrayDeque<T>();
    private final int bufferMaxSize;
    private Runnable drainHandler;
    private boolean shouldSendComplete;
    private boolean complete;

    public BufferedPublisher(Context ctx) {
        this(ctx, 200);
    }

    public BufferedPublisher(Context ctx, Collection<T> initialBuffer) {
        this(ctx);
        this.buffer.addAll(initialBuffer);
        this.complete = true;
        this.shouldSendComplete = true;
    }

    public BufferedPublisher(Context ctx, int bufferMaxSize) {
        super(ctx);
        this.bufferMaxSize = bufferMaxSize;
    }

    public boolean accept(T t) {
        this.checkContext();
        if (this.isComplete() || this.hasSentComplete()) {
            throw new IllegalStateException("Cannot call accept after complete is called");
        }
        if (!this.isCancelled() && !this.isFailed()) {
            if (this.getDemand() == 0L) {
                this.buffer.add(t);
            } else {
                this.doOnNext(t);
            }
        }
        return this.buffer.size() >= this.bufferMaxSize;
    }

    public void drainHandler(Runnable handler) {
        this.checkContext();
        if (this.drainHandler != null) {
            throw new IllegalStateException("drainHandler already set");
        }
        this.drainHandler = Objects.requireNonNull(handler);
    }

    public void complete() {
        this.checkContext();
        if (this.isComplete() || this.isFailed()) {
            return;
        }
        this.complete = true;
        if (this.buffer.isEmpty() && this.getSubscriber() != null) {
            this.sendComplete();
        } else {
            this.shouldSendComplete = true;
        }
    }

    protected boolean isComplete() {
        return this.complete;
    }

    @Override
    protected void maybeSend() {
        int numSent = 0;
        while (this.getDemand() > 0L && !this.buffer.isEmpty()) {
            if (numSent < 200) {
                T val = this.buffer.poll();
                this.doOnNext(val);
                ++numSent;
                continue;
            }
            this.ctx.runOnContext(v -> this.maybeSend());
            break;
        }
        if (this.buffer.isEmpty() && !this.isFailed()) {
            if (this.shouldSendComplete) {
                this.sendComplete();
                this.shouldSendComplete = false;
            } else if (this.getDemand() > 0L && this.drainHandler != null) {
                Runnable handler = this.drainHandler;
                this.ctx.runOnContext(v -> handler.run());
                this.drainHandler = null;
            }
        }
    }
}

