/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.util.DecimalUtil;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class Column
implements SimpleColumn {
    private final ColumnName name;
    private final SqlType type;
    private final Namespace namespace;
    private final int index;
    private final Optional<String> headerKey;

    public static Column of(ColumnName name, SqlType type, Namespace namespace, int indexWithinNamespace) {
        return new Column(name, type, namespace, indexWithinNamespace, Optional.empty());
    }

    public static Column of(ColumnName name, SqlType type, Namespace namespace, int indexWithinNamespace, Optional<String> headerKey) {
        return new Column(name, type, namespace, indexWithinNamespace, headerKey);
    }

    private Column(ColumnName name, SqlType type, Namespace namespace, int index, Optional<String> headerKey) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        this.index = index;
        this.headerKey = Objects.requireNonNull(headerKey, "headerKey");
        if (index < 0) {
            throw new IllegalArgumentException("Invalid column index: " + index);
        }
    }

    @Override
    public ColumnName name() {
        return this.name;
    }

    @Override
    public SqlType type() {
        return this.type;
    }

    public Namespace namespace() {
        return this.namespace;
    }

    public Optional<String> headerKey() {
        return this.headerKey;
    }

    public int index() {
        return this.index;
    }

    public boolean canImplicitlyCast(SqlType toType) {
        if (this.type instanceof SqlDecimal && toType instanceof SqlDecimal) {
            return DecimalUtil.canImplicitlyCast((SqlDecimal)this.type, (SqlDecimal)toType);
        }
        return this.type.equals(toType);
    }

    public boolean equalsIgnoreType(Column that) {
        return Objects.equals(this.index, that.index) && Objects.equals((Object)this.namespace, (Object)that.namespace) && Objects.equals(this.name, that.name) && Objects.equals(this.headerKey, that.headerKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column that = (Column)o;
        return this.equalsIgnoreType(that) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.index, this.namespace, this.name, this.type});
    }

    public String toString() {
        return this.toString(FormatOptions.none());
    }

    public String toString(FormatOptions formatOptions) {
        Object fmtNs = this.namespace == Namespace.HEADERS && this.headerKey.isPresent() ? " HEADER('" + this.headerKey.get() + "')" : (this.namespace == Namespace.VALUE ? "" : " " + String.valueOf((Object)this.namespace));
        String fmtType = this.type.toString(formatOptions);
        return this.name.toString(formatOptions) + " " + fmtType + (String)fmtNs;
    }

    public static enum Namespace {
        KEY,
        VALUE,
        HEADERS;

    }
}

