/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.function.types.ArrayType;
import io.confluent.ksql.function.types.MapType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.types.ParamTypes;
import io.confluent.ksql.function.types.StructType;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlPrimitiveType;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.util.DecimalUtil;
import io.confluent.ksql.util.KsqlException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;

public final class SchemaConverters {
    private static final ConnectToSqlTypeConverter CONNECT_TO_SQL_CONVERTER = new ConnectToSqlConverter();
    private static final SqlToConnectTypeConverter SQL_TO_CONNECT_CONVERTER = new ConnectFromSqlConverter();
    private static final JavaToSqlTypeConverter JAVA_TO_SQL_CONVERTER = new JavaToSqlConverter();
    private static final SqlToJavaTypeConverter SQL_TO_JAVA_CONVERTER = new SqlToJavaConverter();
    private static final SqlToFunctionConverter SQL_TO_FUNCTION_CONVERTER = new SqlToFunction();
    private static final FunctionToSqlConverter FUNCTION_TO_SQL_CONVERTER = new FunctionToSql();
    private static final FunctionToSqlBase FUNCTION_TO_BASE_CONVERTER = new FunctionToSqlBase();

    private SchemaConverters() {
    }

    public static ConnectToSqlTypeConverter connectToSqlConverter() {
        return CONNECT_TO_SQL_CONVERTER;
    }

    public static SqlToConnectTypeConverter sqlToConnectConverter() {
        return SQL_TO_CONNECT_CONVERTER;
    }

    public static ConnectToJavaTypeConverter connectToJavaTypeConverter() {
        return schema -> SchemaConverters.sqlToJavaConverter().toJavaType(SchemaConverters.connectToSqlConverter().toSqlType(schema));
    }

    public static JavaToSqlTypeConverter javaToSqlConverter() {
        return JAVA_TO_SQL_CONVERTER;
    }

    public static SqlToJavaTypeConverter sqlToJavaConverter() {
        return SQL_TO_JAVA_CONVERTER;
    }

    public static SqlToFunctionConverter sqlToFunctionConverter() {
        return SQL_TO_FUNCTION_CONVERTER;
    }

    public static FunctionToSqlConverter functionToSqlConverter() {
        return FUNCTION_TO_SQL_CONVERTER;
    }

    public static FunctionToSqlBaseConverter functionToSqlBaseConverter() {
        return FUNCTION_TO_BASE_CONVERTER;
    }

    public static interface ConnectToSqlTypeConverter {
        public SqlType toSqlType(Schema var1);
    }

    public static interface SqlToConnectTypeConverter {
        public Schema toConnectSchema(SqlType var1);

        public Schema toConnectSchema(SqlType var1, String var2, String var3);
    }

    public static interface ConnectToJavaTypeConverter {
        public Class<?> toJavaType(Schema var1);
    }

    public static interface JavaToSqlTypeConverter {
        public SqlBaseType toSqlType(Class<?> var1);
    }

    public static interface SqlToJavaTypeConverter {
        public Class<?> toJavaType(SqlBaseType var1);

        default public Class<?> toJavaType(SqlType sqlType) {
            return this.toJavaType(sqlType.baseType());
        }
    }

    public static interface SqlToFunctionConverter {
        public ParamType toFunctionType(SqlType var1);
    }

    public static interface FunctionToSqlConverter {
        public SqlType toSqlType(ParamType var1);
    }

    private static class FunctionToSqlBase
    implements FunctionToSqlBaseConverter {
        private static final BiMap<ParamType, SqlBaseType> FUNCTION_TO_BASE = ImmutableBiMap.builder().put((Object)ParamTypes.STRING, (Object)SqlBaseType.STRING).put((Object)ParamTypes.BOOLEAN, (Object)SqlBaseType.BOOLEAN).put((Object)ParamTypes.INTEGER, (Object)SqlBaseType.INTEGER).put((Object)ParamTypes.LONG, (Object)SqlBaseType.BIGINT).put((Object)ParamTypes.DOUBLE, (Object)SqlBaseType.DOUBLE).put((Object)ParamTypes.DECIMAL, (Object)SqlBaseType.DECIMAL).put((Object)ParamTypes.TIME, (Object)SqlBaseType.TIME).put((Object)ParamTypes.DATE, (Object)SqlBaseType.DATE).put((Object)ParamTypes.TIMESTAMP, (Object)SqlBaseType.TIMESTAMP).put((Object)ParamTypes.BYTES, (Object)SqlBaseType.BYTES).build();

        private FunctionToSqlBase() {
        }

        @Override
        public SqlBaseType toBaseType(ParamType paramType) {
            SqlBaseType sqlType = (SqlBaseType)FUNCTION_TO_BASE.get((Object)paramType);
            if (sqlType != null) {
                return sqlType;
            }
            if (paramType instanceof MapType) {
                return SqlBaseType.MAP;
            }
            if (paramType instanceof ArrayType) {
                return SqlBaseType.ARRAY;
            }
            if (paramType instanceof StructType) {
                return SqlBaseType.STRUCT;
            }
            throw new KsqlException("Cannot convert param type to sql type: " + String.valueOf(paramType));
        }
    }

    private static final class ConnectToSqlConverter
    implements ConnectToSqlTypeConverter {
        private static final Map<Schema.Type, Function<Schema, SqlType>> CONNECT_TO_SQL = ImmutableMap.builder().put((Object)Schema.Type.INT32, ConnectToSqlConverter::toIntegerType).put((Object)Schema.Type.INT64, s -> "org.apache.kafka.connect.data.Timestamp".equals(s.name()) ? SqlTypes.TIMESTAMP : SqlTypes.BIGINT).put((Object)Schema.Type.FLOAT64, s -> SqlTypes.DOUBLE).put((Object)Schema.Type.BOOLEAN, s -> SqlTypes.BOOLEAN).put((Object)Schema.Type.STRING, s -> SqlTypes.STRING).put((Object)Schema.Type.ARRAY, ConnectToSqlConverter::toSqlArray).put((Object)Schema.Type.MAP, ConnectToSqlConverter::toSqlMap).put((Object)Schema.Type.STRUCT, ConnectToSqlConverter::toSqlStruct).put((Object)Schema.Type.BYTES, ConnectToSqlConverter::handleBytes).build();

        private ConnectToSqlConverter() {
        }

        @Override
        public SqlType toSqlType(Schema schema) {
            return ConnectToSqlConverter.sqlType(schema);
        }

        private static SqlType sqlType(Schema schema) {
            Function<Schema, SqlType> handler = CONNECT_TO_SQL.get(schema.type());
            if (handler == null) {
                throw new KsqlException("Unexpected schema type: " + String.valueOf(schema));
            }
            return handler.apply(schema);
        }

        private static SqlType handleBytes(Schema schema) {
            if (DecimalUtil.isDecimal(schema)) {
                return SqlDecimal.of((int)DecimalUtil.precision(schema), (int)DecimalUtil.scale(schema));
            }
            return SqlTypes.BYTES;
        }

        private static SqlArray toSqlArray(Schema schema) {
            return SqlArray.of((SqlType)ConnectToSqlConverter.sqlType(schema.valueSchema()));
        }

        private static SqlMap toSqlMap(Schema schema) {
            return SqlMap.of((SqlType)ConnectToSqlConverter.sqlType(schema.keySchema()), (SqlType)ConnectToSqlConverter.sqlType(schema.valueSchema()));
        }

        private static SqlStruct toSqlStruct(Schema schema) {
            SqlStruct.Builder builder = SqlStruct.builder();
            schema.schema().fields().forEach(field -> builder.field(field.name(), ConnectToSqlConverter.sqlType(field.schema())));
            return builder.build();
        }

        private static SqlPrimitiveType toIntegerType(Schema schema) {
            if ("org.apache.kafka.connect.data.Time".equals(schema.name())) {
                return SqlTypes.TIME;
            }
            if ("org.apache.kafka.connect.data.Date".equals(schema.name())) {
                return SqlTypes.DATE;
            }
            return SqlTypes.INTEGER;
        }
    }

    private static final class ConnectFromSqlConverter
    implements SqlToConnectTypeConverter {
        private static final Map<SqlBaseType, Function<SqlType, SchemaBuilder>> SQL_TO_CONNECT = ImmutableMap.builder().put((Object)SqlBaseType.STRING, t -> SchemaBuilder.string().optional()).put((Object)SqlBaseType.BOOLEAN, t -> SchemaBuilder.bool().optional()).put((Object)SqlBaseType.INTEGER, t -> SchemaBuilder.int32().optional()).put((Object)SqlBaseType.BIGINT, t -> SchemaBuilder.int64().optional()).put((Object)SqlBaseType.DOUBLE, t -> SchemaBuilder.float64().optional()).put((Object)SqlBaseType.DECIMAL, t -> ConnectFromSqlConverter.fromSqlDecimal((SqlDecimal)t)).put((Object)SqlBaseType.ARRAY, t -> ConnectFromSqlConverter.fromSqlArray((SqlArray)t)).put((Object)SqlBaseType.MAP, t -> ConnectFromSqlConverter.fromSqlMap((SqlMap)t)).put((Object)SqlBaseType.STRUCT, t -> ConnectFromSqlConverter.fromSqlStruct((SqlStruct)t)).put((Object)SqlBaseType.TIME, t -> Time.builder().optional()).put((Object)SqlBaseType.DATE, t -> org.apache.kafka.connect.data.Date.builder().optional()).put((Object)SqlBaseType.TIMESTAMP, t -> org.apache.kafka.connect.data.Timestamp.builder().optional()).put((Object)SqlBaseType.BYTES, t -> SchemaBuilder.bytes().optional()).build();

        private ConnectFromSqlConverter() {
        }

        @Override
        public Schema toConnectSchema(SqlType type) {
            return ConnectFromSqlConverter.connectType(type).build();
        }

        @Override
        public Schema toConnectSchema(SqlType type, String name, String doc) {
            return ConnectFromSqlConverter.connectType(type).name(name).doc(doc).build();
        }

        private static SchemaBuilder connectType(SqlType sqlType) {
            Function<SqlType, SchemaBuilder> handler = SQL_TO_CONNECT.get(sqlType.baseType());
            if (handler == null) {
                throw new KsqlException("Unexpected sql type: " + String.valueOf(sqlType));
            }
            return handler.apply(sqlType);
        }

        private static SchemaBuilder fromSqlDecimal(SqlDecimal sqlDecimal) {
            return DecimalUtil.builder(sqlDecimal.getPrecision(), sqlDecimal.getScale());
        }

        private static SchemaBuilder fromSqlArray(SqlArray sqlArray) {
            return SchemaBuilder.array((Schema)ConnectFromSqlConverter.connectType(sqlArray.getItemType()).build()).optional();
        }

        private static SchemaBuilder fromSqlMap(SqlMap sqlMap) {
            return SchemaBuilder.map((Schema)ConnectFromSqlConverter.connectType(sqlMap.getKeyType()).build(), (Schema)ConnectFromSqlConverter.connectType(sqlMap.getValueType()).build()).optional();
        }

        private static SchemaBuilder fromSqlStruct(SqlStruct struct) {
            SchemaBuilder builder = SchemaBuilder.struct();
            struct.fields().forEach(field -> builder.field(field.name(), ConnectFromSqlConverter.connectType(field.type()).build()));
            Optional unionType = struct.unionType();
            if (unionType.isPresent()) {
                switch ((SqlStruct.UnionType)unionType.get()) {
                    case ONE_OF_TYPE: {
                        builder.name("io.confluent.connect.json.OneOf");
                        break;
                    }
                    case GENERALIZED_TYPE: {
                        builder.parameter("org.apache.kafka.connect.data.Union", "0");
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + String.valueOf(struct.unionType()));
                    }
                }
            }
            return builder.optional();
        }
    }

    private static class JavaToSqlConverter
    implements JavaToSqlTypeConverter {
        private static final BiMap<Class<?>, SqlBaseType> JAVA_TO_SQL = ImmutableBiMap.builder().put(Boolean.class, (Object)SqlBaseType.BOOLEAN).put(Integer.class, (Object)SqlBaseType.INTEGER).put(Long.class, (Object)SqlBaseType.BIGINT).put(Double.class, (Object)SqlBaseType.DOUBLE).put(String.class, (Object)SqlBaseType.STRING).put(BigDecimal.class, (Object)SqlBaseType.DECIMAL).put(List.class, (Object)SqlBaseType.ARRAY).put(Map.class, (Object)SqlBaseType.MAP).put(Struct.class, (Object)SqlBaseType.STRUCT).put(java.sql.Time.class, (Object)SqlBaseType.TIME).put(Date.class, (Object)SqlBaseType.DATE).put(Timestamp.class, (Object)SqlBaseType.TIMESTAMP).put(ByteBuffer.class, (Object)SqlBaseType.BYTES).build();

        private JavaToSqlConverter() {
        }

        @Override
        public SqlBaseType toSqlType(Class<?> javaType) {
            return JAVA_TO_SQL.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(javaType)).map(Map.Entry::getValue).findAny().orElseThrow(() -> new KsqlException("Unexpected java type: " + String.valueOf(javaType)));
        }
    }

    private static class SqlToJavaConverter
    implements SqlToJavaTypeConverter {
        private static final BiMap<SqlBaseType, Class<?>> SQL_TO_JAVA = JavaToSqlConverter.JAVA_TO_SQL.inverse();

        private SqlToJavaConverter() {
        }

        @Override
        public Class<?> toJavaType(SqlBaseType sqlBaseType) {
            Class javaType = (Class)SQL_TO_JAVA.get((Object)sqlBaseType);
            if (javaType == null) {
                throw new KsqlException("Unexpected sql type: " + String.valueOf(sqlBaseType));
            }
            return javaType;
        }
    }

    private static class SqlToFunction
    implements SqlToFunctionConverter {
        private SqlToFunction() {
        }

        @Override
        public ParamType toFunctionType(SqlType sqlType) {
            ParamType paramType = (ParamType)FunctionToSql.FUNCTION_TO_SQL.inverse().get((Object)sqlType);
            if (paramType != null) {
                return paramType;
            }
            if (sqlType.baseType() == SqlBaseType.DECIMAL) {
                return ParamTypes.DECIMAL;
            }
            if (sqlType.baseType() == SqlBaseType.ARRAY) {
                return ArrayType.of(this.toFunctionType(((SqlArray)sqlType).getItemType()));
            }
            if (sqlType.baseType() == SqlBaseType.MAP) {
                SqlMap sqlMap = (SqlMap)sqlType;
                return MapType.of(this.toFunctionType(sqlMap.getKeyType()), this.toFunctionType(sqlMap.getValueType()));
            }
            if (sqlType.baseType() == SqlBaseType.STRUCT) {
                StructType.Builder builder = StructType.builder();
                for (SqlStruct.Field field : ((SqlStruct)sqlType).fields()) {
                    builder.field(field.name(), this.toFunctionType(field.type()));
                }
                return builder.build();
            }
            throw new KsqlException("Cannot convert sql type to param type: " + String.valueOf(sqlType));
        }
    }

    private static class FunctionToSql
    implements FunctionToSqlConverter {
        private static final BiMap<ParamType, SqlType> FUNCTION_TO_SQL = ImmutableBiMap.builder().put((Object)ParamTypes.STRING, (Object)SqlTypes.STRING).put((Object)ParamTypes.BOOLEAN, (Object)SqlTypes.BOOLEAN).put((Object)ParamTypes.INTEGER, (Object)SqlTypes.INTEGER).put((Object)ParamTypes.LONG, (Object)SqlTypes.BIGINT).put((Object)ParamTypes.DOUBLE, (Object)SqlTypes.DOUBLE).put((Object)ParamTypes.TIME, (Object)SqlTypes.TIME).put((Object)ParamTypes.DATE, (Object)SqlTypes.DATE).put((Object)ParamTypes.TIMESTAMP, (Object)SqlTypes.TIMESTAMP).put((Object)ParamTypes.BYTES, (Object)SqlTypes.BYTES).build();

        private FunctionToSql() {
        }

        @Override
        public SqlType toSqlType(ParamType paramType) {
            SqlType sqlType = (SqlType)FUNCTION_TO_SQL.get((Object)paramType);
            if (sqlType != null) {
                return sqlType;
            }
            if (paramType instanceof MapType) {
                MapType mapType = (MapType)paramType;
                SqlType keyType = this.toSqlType(mapType.key());
                SqlType valueType = this.toSqlType(mapType.value());
                return SqlTypes.map((SqlType)keyType, (SqlType)valueType);
            }
            if (paramType instanceof ArrayType) {
                return SqlTypes.array((SqlType)this.toSqlType(((ArrayType)paramType).element()));
            }
            if (paramType instanceof StructType) {
                SqlStruct.Builder struct = SqlTypes.struct();
                ((StructType)paramType).getSchema().forEach((name, type) -> struct.field(name, this.toSqlType((ParamType)type)));
                return struct.build();
            }
            throw new KsqlException("Cannot convert param type to sql type: " + String.valueOf(paramType));
        }
    }

    public static interface FunctionToSqlBaseConverter {
        public SqlBaseType toBaseType(ParamType var1);
    }
}

