/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import io.confluent.ksql.security.Credentials;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.config.ConfigException;

public final class BasicCredentials
implements Credentials {
    private String username;
    private String password;

    public void configure(Map<String, ?> map) {
        this.validateConfigs(map);
        this.username = (String)map.get("ksql.auth.basic.username");
        this.password = (String)map.get("ksql.auth.basic.password");
    }

    public static BasicCredentials of(String username, String password) {
        BasicCredentials basicCredentials = new BasicCredentials();
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("ksql.auth.basic.username", username);
        configs.put("ksql.auth.basic.password", password);
        basicCredentials.configure(configs);
        return basicCredentials;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicCredentials that = (BasicCredentials)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password);
    }

    @Override
    public String getAuthHeader() {
        return "Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void validateConfigs(Map<String, ?> configs) throws ConfigException {
        String username = (String)configs.get("ksql.auth.basic.username");
        String password = (String)configs.get("ksql.auth.basic.password");
        if (username == null || username.isEmpty() || password == null || password.isEmpty()) {
            throw new ConfigException("Cannot configure BasicCredentials without proper username or password");
        }
    }
}

