/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.oauth;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.security.oauth.OAuthTokenCache;
import io.confluent.ksql.security.oauth.exceptions.KsqlOAuthTokenRetrieverException;
import org.apache.kafka.common.security.oauthbearer.JwtRetriever;
import org.apache.kafka.common.security.oauthbearer.JwtRetrieverException;
import org.apache.kafka.common.security.oauthbearer.JwtValidator;
import org.apache.kafka.common.security.oauthbearer.JwtValidatorException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;

public class CachedOAuthTokenRetriever {
    private final JwtRetriever accessTokenRetriever;
    private final JwtValidator accessTokenValidator;
    private final OAuthTokenCache authTokenCache;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public CachedOAuthTokenRetriever(JwtRetriever accessTokenRetriever, JwtValidator accessTokenValidator, OAuthTokenCache authTokenCache) {
        this.accessTokenRetriever = accessTokenRetriever;
        this.accessTokenValidator = accessTokenValidator;
        this.authTokenCache = authTokenCache;
    }

    public String getToken() {
        if (this.authTokenCache.isTokenExpired()) {
            OAuthBearerToken oauthBearerToken;
            String token = null;
            try {
                token = this.accessTokenRetriever.retrieve();
            }
            catch (JwtRetrieverException e) {
                throw new KsqlOAuthTokenRetrieverException("Failed to Retrieve OAuth Token for KSQL", e);
            }
            try {
                oauthBearerToken = this.accessTokenValidator.validate(token);
            }
            catch (JwtValidatorException e) {
                throw new KsqlOAuthTokenRetrieverException("OAuth Token for KSQL is Invalid", e);
            }
            this.authTokenCache.setCurrentToken(oauthBearerToken);
        }
        return this.authTokenCache.getCurrentToken().value();
    }
}

