/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AppInfo {
    private static final Logger log;
    private static String version;
    private static String commitId;

    private AppInfo() {
    }

    public static String getVersion() {
        return version;
    }

    public static String getCommitId() {
        return commitId;
    }

    public static void main(String[] args) {
        System.err.println(AppInfo.getVersion());
        System.err.println(AppInfo.getCommitId());
    }

    static {
        InputStream resourceAsStream;
        Properties props;
        log = LogManager.getLogger(AppInfo.class);
        version = "unknown";
        commitId = "unknown";
        try {
            props = new Properties();
            resourceAsStream = AppInfo.class.getResourceAsStream("/ksqldb/version.properties");
            try {
                props.load(resourceAsStream);
            }
            finally {
                if (resourceAsStream != null) {
                    resourceAsStream.close();
                }
            }
            version = props.getProperty("version", version).trim();
        }
        catch (Exception e) {
            log.warn("Error while loading version:", (Throwable)e);
        }
        try {
            props = new Properties();
            resourceAsStream = AppInfo.class.getResourceAsStream("/git.properties");
            try {
                props.load(resourceAsStream);
            }
            finally {
                if (resourceAsStream != null) {
                    resourceAsStream.close();
                }
            }
            commitId = props.getProperty("git.commit.id", commitId).trim();
        }
        catch (Exception e) {
            log.warn("Error while loading git properties:", (Throwable)e);
        }
    }
}

