/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.util.Objects;

public class KeyValue<K, V> {
    private final K key;
    private final V value;

    public KeyValue(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public static <K, V> KeyValue<K, V> keyValue(K key, V value) {
        return new KeyValue<K, V>(key, value);
    }

    public K key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValue keyValue = (KeyValue)o;
        return Objects.equals(this.key, keyValue.key) && Objects.equals(this.value, keyValue.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return "(" + String.valueOf(this.key) + ", " + String.valueOf(this.value) + ")";
    }
}

