/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.util.KsqlException;

public class KsqlStatementException
extends KsqlException {
    private final String sqlStatement;
    private final Problem problem;
    private final String rawMessage;
    private final String unloggedDetails;
    private final String rawUnloggedDetails;

    public KsqlStatementException(String message, String sqlStatement) {
        super(message);
        this.rawMessage = message == null ? "" : message;
        this.sqlStatement = sqlStatement == null ? "" : sqlStatement;
        this.problem = Problem.STATEMENT;
        this.rawUnloggedDetails = this.rawMessage;
        this.unloggedDetails = KsqlStatementException.buildMessage(message, sqlStatement);
    }

    public KsqlStatementException(String message, String unloggedDetails, String sqlStatement) {
        super(message);
        this.rawMessage = message == null ? "" : message;
        this.sqlStatement = sqlStatement == null ? "" : sqlStatement;
        this.problem = Problem.STATEMENT;
        this.rawUnloggedDetails = unloggedDetails;
        this.unloggedDetails = KsqlStatementException.buildMessage(unloggedDetails, sqlStatement);
    }

    public KsqlStatementException(String message, String sqlStatement, Problem problem) {
        super(message);
        this.rawMessage = message == null ? "" : message;
        this.sqlStatement = sqlStatement == null ? "" : sqlStatement;
        this.problem = problem;
        this.rawUnloggedDetails = this.rawMessage;
        this.unloggedDetails = null;
    }

    public KsqlStatementException(String message, String unloggedDetails, String sqlStatement, Problem problem) {
        super(message);
        this.rawMessage = message == null ? "" : message;
        this.sqlStatement = sqlStatement == null ? "" : sqlStatement;
        this.problem = problem;
        this.rawUnloggedDetails = unloggedDetails;
        this.unloggedDetails = KsqlStatementException.buildMessage(unloggedDetails, sqlStatement);
    }

    public KsqlStatementException(String message, String sqlStatement, Throwable cause) {
        super(message, cause);
        this.rawMessage = message == null ? "" : message;
        this.sqlStatement = sqlStatement == null ? "" : sqlStatement;
        this.problem = Problem.STATEMENT;
        this.rawUnloggedDetails = this.rawMessage;
        this.unloggedDetails = null;
    }

    public KsqlStatementException(String message, String unloggedDetails, String sqlStatement, Throwable cause) {
        super(message, cause);
        this.rawMessage = message == null ? "" : message;
        this.sqlStatement = sqlStatement == null ? "" : sqlStatement;
        this.rawUnloggedDetails = unloggedDetails;
        this.unloggedDetails = KsqlStatementException.buildMessage(unloggedDetails, sqlStatement);
        this.problem = Problem.STATEMENT;
    }

    public KsqlStatementException(String message, String sqlStatement, Problem problem, Throwable cause) {
        super(message, cause);
        this.rawMessage = message == null ? "" : message;
        this.sqlStatement = sqlStatement == null ? "" : sqlStatement;
        this.problem = problem;
        this.rawUnloggedDetails = this.rawMessage;
        this.unloggedDetails = null;
    }

    public KsqlStatementException(String message, String unloggedDetails, String sqlStatement, Problem problem, Throwable cause) {
        super(message, cause);
        this.rawMessage = message == null ? "" : message;
        this.sqlStatement = sqlStatement == null ? "" : sqlStatement;
        this.problem = problem;
        this.rawUnloggedDetails = unloggedDetails;
        this.unloggedDetails = problem == Problem.OTHER ? unloggedDetails : KsqlStatementException.buildMessage(unloggedDetails, sqlStatement);
    }

    public String getSqlStatement() {
        return this.sqlStatement;
    }

    public String getRawMessage() {
        return this.rawMessage;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public String getUnloggedMessage() {
        return this.unloggedDetails == null ? this.getMessage() : this.unloggedDetails;
    }

    public String getRawUnloggedDetails() {
        return this.rawUnloggedDetails;
    }

    private static String buildMessage(String message, String sqlStatement) {
        return message + System.lineSeparator() + "Statement: " + sqlStatement;
    }

    public static enum Problem {
        STATEMENT,
        REQUEST,
        OTHER;

    }
}

