/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KsqlVersion {
    private static final Pattern VERSION_PATTERN = Pattern.compile("v?([0-9]+)\\.([0-9]+)\\..*");
    private static final Map<KsqlVersion, KsqlVersion> versionMapping = new HashMap<KsqlVersion, KsqlVersion>();
    private static final KsqlVersion CP_60 = new KsqlVersion("6.0.");
    private static final KsqlVersion CP_61 = new KsqlVersion("6.1.");
    private static final KsqlVersion V_010 = new KsqlVersion("0.10.");
    private static final KsqlVersion V_014 = new KsqlVersion("0.14.");
    private final VersionType versionType;
    private final String originalVersion;
    private final int majorVersion;
    private final int minorVersion;

    public KsqlVersion(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Unexpected ksqlDB server version: " + version);
        }
        this.originalVersion = version;
        this.majorVersion = Integer.parseInt(matcher.group(1));
        this.minorVersion = Integer.parseInt(matcher.group(2));
        this.versionType = this.majorVersion < 4 ? VersionType.KSQLDB_STANDALONE : VersionType.CONFLUENT_PLATFORM;
    }

    public boolean isAtLeast(KsqlVersion version) {
        if (this.versionType == version.versionType) {
            return KsqlVersion.isAtLeastVersion(this, version.majorVersion, version.minorVersion);
        }
        if (this.versionType == VersionType.KSQLDB_STANDALONE) {
            KsqlVersion otherStandalone = versionMapping.get(version);
            return otherStandalone != null && KsqlVersion.isAtLeastVersion(this, otherStandalone.majorVersion, otherStandalone.minorVersion);
        }
        KsqlVersion standalone = versionMapping.get(this);
        return standalone != null && KsqlVersion.isAtLeastVersion(standalone, version.majorVersion, version.minorVersion);
    }

    private static boolean isAtLeastVersion(KsqlVersion version, int major, int minor) {
        if (version.majorVersion > major) {
            return true;
        }
        if (version.majorVersion < major) {
            return false;
        }
        return version.minorVersion >= minor;
    }

    public boolean same(KsqlVersion version) {
        return this.isAtLeast(version) && version.isAtLeast(this);
    }

    public VersionType type() {
        return this.versionType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.versionType, this.majorVersion, this.minorVersion});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KsqlVersion that = (KsqlVersion)o;
        return this.versionType == that.versionType && this.majorVersion == that.majorVersion && this.minorVersion == that.minorVersion;
    }

    public String toString() {
        return this.originalVersion;
    }

    static {
        versionMapping.put(CP_60, V_010);
        versionMapping.put(CP_61, V_014);
    }

    public static enum VersionType {
        CONFLUENT_PLATFORM,
        KSQLDB_STANDALONE;

    }
}

