/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.PushOffsetVector;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PushOffsetRange {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final int version;
    private final Optional<PushOffsetVector> startOffsets;
    private final PushOffsetVector endOffsets;

    @JsonCreator
    public PushOffsetRange(@JsonProperty(value="s") Optional<PushOffsetVector> startOffsets, @JsonProperty(value="e", required=true) PushOffsetVector endOffsets, @JsonProperty(value="v", required=true) int version) {
        this.startOffsets = startOffsets;
        this.endOffsets = endOffsets;
        this.version = version;
    }

    public PushOffsetRange(Optional<PushOffsetVector> startOffsets, PushOffsetVector endOffsets) {
        this.startOffsets = startOffsets;
        this.endOffsets = endOffsets;
        this.version = 0;
    }

    @JsonProperty(value="s")
    public Optional<PushOffsetVector> getStartOffsets() {
        return this.startOffsets.map(o -> o);
    }

    @JsonProperty(value="e")
    public PushOffsetVector getEndOffsets() {
        return this.endOffsets;
    }

    @JsonProperty(value="v")
    public int getVersion() {
        return this.version;
    }

    public String serialize() {
        try {
            byte[] bytes = OBJECT_MAPPER.writeValueAsBytes((Object)this);
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            throw new KsqlException("Couldn't encode push offset range token", e);
        }
    }

    public static PushOffsetRange deserialize(String token) {
        try {
            byte[] bytes = Base64.getDecoder().decode(token);
            return (PushOffsetRange)OBJECT_MAPPER.readValue(bytes, PushOffsetRange.class);
        }
        catch (Exception e) {
            throw new KsqlException("Couldn't decode push offset range token", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushOffsetRange that = (PushOffsetRange)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.startOffsets, that.startOffsets) && Objects.equals(this.endOffsets, that.endOffsets);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.startOffsets, this.endOffsets);
    }

    @JsonIgnore
    public String toString() {
        return "PushOffsetRange{version=" + this.version + ", startOffsets=" + String.valueOf(this.startOffsets) + ", endOffsets=" + String.valueOf(this.endOffsets) + "}";
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
    }
}

