/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.http;

import io.confluent.security.authentication.credential.HttpCredential;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientAuthFilter
implements ClientRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(HttpClientAuthFilter.class);
    private final HttpCredential httpCredential;

    public HttpClientAuthFilter(HttpCredential httpCredential) {
        this.httpCredential = httpCredential;
    }

    public void filter(ClientRequestContext requestContext) {
        if (this.httpCredential == null) {
            return;
        }
        requestContext.getHeaders().add((Object)"Authorization", (Object)String.format("%s %s", new Object[]{this.httpCredential.scheme(), this.httpCredential.authParams()}));
    }
}

