/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.mtls;

import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum CertMetadataIdentifier {
    DC("DC", "Domain Component"),
    CN("CN", "Common Name"),
    OU("OU", "Organizational Unit"),
    O("O", "Organization"),
    STREET("STREET", "Street"),
    L("L", "Locality"),
    ST("ST", "State"),
    C("C", "Country"),
    UID("UID", "User ID"),
    DN("DN", "Subject Distinguished Name"),
    SAN("SAN", "Subject Alternative Name"),
    SNID("SNID", "Serial Number"),
    SHA1("SHA1", "SHA1 Fingerprint");

    public static final Set<String> IDENTIFIERS;
    private final String value;
    private final String description;

    private CertMetadataIdentifier(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        IDENTIFIERS = EnumSet.allOf(CertMetadataIdentifier.class).stream().map(CertMetadataIdentifier::getValue).collect(Collectors.toSet());
    }
}

