/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.remote.config.poller.kubernetes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSet {
    private static final Logger log = LoggerFactory.getLogger(ConfigSet.class);
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final Set<ConfigSetEntry> configs;

    private ConfigSet(Set<ConfigSetEntry> configs) {
        this.configs = configs;
    }

    public static ConfigSet parseConfigYaml(String configs) throws JsonProcessingException {
        return new ConfigSet((Set)MAPPER.readValue(configs, (TypeReference)new TypeReference<Set<ConfigSetEntry>>(){}));
    }

    public <T> Optional<T> getCompatibleConfigVersion(String schemaVersion, Class<T> typeParameterClass) {
        for (ConfigSetEntry entry : this.configs) {
            if (!ConfigSet.isVersionCompatible(schemaVersion, entry.getVersion())) continue;
            log.info("Using config version: " + entry.getVersion());
            return Optional.of(MAPPER.convertValue((Object)entry.getConfig(), typeParameterClass));
        }
        log.info("No compatible config versions found. Client Config Version {}. Found Config Versions: {}", (Object)schemaVersion, this.configs.stream().map(ConfigSetEntry::getVersion).collect(Collectors.toSet()));
        return Optional.empty();
    }

    private static boolean isVersionCompatible(String version, String versionToCompare) {
        if (versionToCompare.length() < 3 || version.length() < 3) {
            return false;
        }
        int versionMajor = Integer.parseInt(version.split("[.]")[0]);
        int versionToCompareMajor = Integer.parseInt(versionToCompare.split("[.]")[0]);
        int versionMinor = Integer.parseInt(version.split("[.]")[1]);
        int versionToCompareMinor = Integer.parseInt(versionToCompare.split("[.]")[1]);
        return versionMajor == versionToCompareMajor && versionMinor <= versionToCompareMinor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigSet configSet = (ConfigSet)o;
        return Objects.equals(this.configs, configSet.configs);
    }

    public int hashCode() {
        return Objects.hash(this.configs);
    }

    @VisibleForTesting
    static class ConfigSetEntry {
        private final String version;
        private final JsonNode config;

        @JsonCreator
        public ConfigSetEntry(@JsonProperty(value="version") String version, @JsonProperty(value="value") JsonNode config) {
            this.version = version;
            this.config = config;
        }

        public String getVersion() {
            return this.version;
        }

        public JsonNode getConfig() {
            return this.config;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigSetEntry that = (ConfigSetEntry)o;
            return Objects.equals(this.version, that.version) && Objects.equals(this.config, that.config);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.config);
        }
    }
}

