/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SchemaMetadata {
    private String subject;
    private int id;
    private int version;
    private String guid;
    private String schemaType;
    private String schema;
    private List<SchemaReference> references;
    private Metadata metadata = null;
    private RuleSet ruleSet = null;
    private Long timestamp = null;
    private Boolean deleted = null;

    public SchemaMetadata(int id, int version, String schema) {
        this(id, version, "AVRO", Collections.emptyList(), schema);
    }

    public SchemaMetadata(int id, int version, String schemaType, List<SchemaReference> references, String schema) {
        this.id = id;
        this.version = version;
        this.schemaType = schemaType;
        this.schema = schema;
        this.references = references;
    }

    public SchemaMetadata(Schema schema) {
        this.subject = schema.getSubject();
        this.id = schema.getId();
        this.guid = schema.getGuid();
        this.version = schema.getVersion();
        this.guid = schema.getGuid();
        this.schemaType = schema.getSchemaType();
        this.schema = schema.getSchema();
        this.references = schema.getReferences();
        this.metadata = schema.getMetadata();
        this.ruleSet = schema.getRuleSet();
        this.timestamp = schema.getTimestamp();
        this.deleted = schema.getDeleted();
    }

    public String getSubject() {
        return this.subject;
    }

    public int getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public String getSchema() {
        return this.schema;
    }

    public List<SchemaReference> getReferences() {
        return this.references;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaMetadata that = (SchemaMetadata)o;
        return Objects.equals(this.subject, that.subject) && this.id == that.id && this.version == that.version && Objects.equals(this.guid, that.guid) && Objects.equals(this.schemaType, that.schemaType) && Objects.equals(this.schema, that.schema) && Objects.equals(this.references, that.references) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.ruleSet, that.ruleSet);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.id, this.version, this.guid, this.schemaType, this.schema, this.references, this.metadata, this.ruleSet);
    }
}

