/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Mode update request")
public class ModeUpdateRequest {
    private Optional<String> mode;

    public static ModeUpdateRequest fromJson(String json) throws IOException {
        return (ModeUpdateRequest)JacksonMapper.INSTANCE.readValue(json, ModeUpdateRequest.class);
    }

    public ModeUpdateRequest() {
    }

    public ModeUpdateRequest(Optional<String> mode) {
        this.setMode(mode);
    }

    public ModeUpdateRequest(String mode) {
        this.setMode(mode);
    }

    @Schema(description="Schema Registry operating mode", allowableValues={"READWRITE", "READONLY", "READONLY_OVERRIDE", "IMPORT"}, example="READWRITE")
    @JsonProperty(value="mode")
    public Optional<String> getOptionalMode() {
        return this.mode;
    }

    @JsonIgnore
    public String getMode() {
        return this.mode != null ? (String)this.mode.orElse(null) : null;
    }

    @JsonProperty(value="mode")
    public void setMode(Optional<String> mode) {
        this.mode = mode;
    }

    @JsonIgnore
    public void setMode(String mode) {
        this.mode = mode != null ? Optional.of(mode) : null;
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModeUpdateRequest that = (ModeUpdateRequest)o;
        return Objects.equals(this.mode, that.mode);
    }

    public int hashCode() {
        return Objects.hash(this.mode);
    }
}

