/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.MultiChildLoadBalancer;
import io.grpc.xds.ClusterManagerLoadBalancerProvider;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsNameResolver;
import java.util.HashMap;
import java.util.Map;

class ClusterManagerLoadBalancer
extends MultiChildLoadBalancer {
    private final XdsLogger logger;

    ClusterManagerLoadBalancer(LoadBalancer.Helper helper) {
        super(helper);
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"cluster_manager-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    protected Map<Object, ServiceConfigUtil.PolicySelection> getPolicySelectionMap(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        ClusterManagerLoadBalancerProvider.ClusterManagerConfig config = (ClusterManagerLoadBalancerProvider.ClusterManagerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        HashMap<Object, ServiceConfigUtil.PolicySelection> newChildPolicies = new HashMap<Object, ServiceConfigUtil.PolicySelection>(config.childPolicies);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received cluster_manager lb config: child names={0}", newChildPolicies.keySet());
        return newChildPolicies;
    }

    protected LoadBalancer.SubchannelPicker getSubchannelPicker(final Map<Object, LoadBalancer.SubchannelPicker> childPickers) {
        return new LoadBalancer.SubchannelPicker(){

            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                String clusterName = (String)args.getCallOptions().getOption(XdsNameResolver.CLUSTER_SELECTION_KEY);
                LoadBalancer.SubchannelPicker childPicker = (LoadBalancer.SubchannelPicker)childPickers.get(clusterName);
                if (childPicker == null) {
                    return LoadBalancer.PickResult.withError((Status)Status.UNAVAILABLE.withDescription("CDS encountered error: unable to find available subchannel for cluster " + clusterName));
                }
                return childPicker.pickSubchannel(args);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)((Object)this)).add("pickers", (Object)childPickers).toString();
            }
        };
    }
}

