/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.util.Objects;
import org.apache.kafka.streams.internals.ApiUtils;

public final class SlidingWindows {
    private final long timeDifferenceMs;
    private final long graceMs;

    private SlidingWindows(long timeDifferenceMs, long graceMs) {
        this.timeDifferenceMs = timeDifferenceMs;
        this.graceMs = graceMs;
        if (timeDifferenceMs < 0L) {
            throw new IllegalArgumentException("Window time difference must not be negative.");
        }
        if (graceMs < 0L) {
            throw new IllegalArgumentException("Window grace period must not be negative.");
        }
    }

    public static SlidingWindows ofTimeDifferenceWithNoGrace(Duration timeDifference) throws IllegalArgumentException {
        return SlidingWindows.ofTimeDifferenceAndGrace(timeDifference, Duration.ofMillis(0L));
    }

    public static SlidingWindows ofTimeDifferenceAndGrace(Duration timeDifference, Duration afterWindowEnd) throws IllegalArgumentException {
        String timeDifferenceMsgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(timeDifference, "timeDifference");
        long timeDifferenceMs = ApiUtils.validateMillisecondDuration(timeDifference, timeDifferenceMsgPrefix);
        String afterWindowEndMsgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(afterWindowEnd, "afterWindowEnd");
        long afterWindowEndMs = ApiUtils.validateMillisecondDuration(afterWindowEnd, afterWindowEndMsgPrefix);
        return new SlidingWindows(timeDifferenceMs, afterWindowEndMs);
    }

    public long timeDifferenceMs() {
        return this.timeDifferenceMs;
    }

    public long gracePeriodMs() {
        return this.graceMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlidingWindows that = (SlidingWindows)o;
        return this.timeDifferenceMs == that.timeDifferenceMs && this.graceMs == that.graceMs;
    }

    public int hashCode() {
        return Objects.hash(this.timeDifferenceMs, this.graceMs);
    }

    public String toString() {
        return "SlidingWindows{, sizeMs=" + this.timeDifferenceMs + ", graceMs=" + this.graceMs + "}";
    }
}

